/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.mouse;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Vector3d;

public class MouseWheelZoom
extends MouseBehavior {
    double z_factor = 0.1;
    Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;

    public MouseWheelZoom(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public MouseWheelZoom() {
        super(0);
    }

    public MouseWheelZoom(int flags) {
        super(flags);
    }

    public MouseWheelZoom(Component c) {
        super(c, 0);
    }

    public MouseWheelZoom(Component c, TransformGroup transformGroup) {
        super(c, transformGroup);
    }

    public MouseWheelZoom(Component c, int flags) {
        super(c, flags);
    }

    @Override
    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.z_factor *= -1.0;
            this.invert = true;
        }
    }

    public double getFactor() {
        return this.z_factor;
    }

    public void setFactor(double factor) {
        this.z_factor = factor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStimulus(Enumeration criteria) {
        block3: while (criteria.hasMoreElements()) {
            MouseEvent evt;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                evt = (MouseEvent)events[events.length - 1];
                this.doProcess(evt);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    evt = (MouseEvent)this.mouseq.remove(0);
                    while (evt.getID() == 507 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 507) {
                        evt = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(evt);
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    void doProcess(MouseEvent evt) {
        int units = 0;
        this.processMouseEvent(evt);
        if (evt.getID() == 507) {
            MouseWheelEvent wheelEvent = (MouseWheelEvent)evt;
            if (wheelEvent.getScrollType() == 0) {
                units = wheelEvent.getUnitsToScroll();
            }
            if (!this.reset) {
                this.transformGroup.getTransform(this.currXform);
                this.translation.z = (double)units * this.z_factor;
                this.transformX.set(this.translation);
                if (this.invert) {
                    this.currXform.mul(this.currXform, this.transformX);
                } else {
                    this.currXform.mul(this.transformX, this.currXform);
                }
                this.transformGroup.setTransform(this.currXform);
                this.transformChanged(this.currXform);
                if (this.callback != null) {
                    this.callback.transformChanged(2, this.currXform);
                }
            } else {
                this.reset = false;
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }
}

