/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.vp;

import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;

public abstract class ViewPlatformAWTBehavior
extends ViewPlatformBehavior
implements MouseListener,
MouseMotionListener,
KeyListener,
MouseWheelListener {
    private static final boolean DEBUG = false;
    protected static final int POST_ID = 9998;
    protected WakeupOnElapsedFrames frameWakeup;
    protected WakeupOnBehaviorPost postWakeup;
    protected Transform3D targetTransform = new Transform3D();
    protected boolean motion = false;
    public static final int MOUSE_LISTENER = 1;
    public static final int MOUSE_MOTION_LISTENER = 2;
    public static final int KEY_LISTENER = 4;
    public static final int MOUSE_WHEEL_LISTENER = 8;
    protected Canvas3D[] canvases;
    private ArrayList eventQueue = new ArrayList();
    private int listenerFlags = 0;
    private boolean firstEvent = false;

    protected ViewPlatformAWTBehavior() {
    }

    protected ViewPlatformAWTBehavior(int listenerFlags) {
        this.setListenerFlags(listenerFlags);
    }

    public ViewPlatformAWTBehavior(Canvas3D c, int listenerFlags) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.canvases = new Canvas3D[]{c};
        this.setListenerFlags(listenerFlags);
    }

    protected void setListenerFlags(int listenerFlags) {
        this.listenerFlags = listenerFlags;
    }

    public void initialize() {
        this.frameWakeup = new WakeupOnElapsedFrames(0);
        this.postWakeup = new WakeupOnBehaviorPost((Behavior)this, 9998);
        this.wakeupOn((WakeupCondition)this.postWakeup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration behEnum) {
        boolean hadPost = false;
        while (behEnum.hasMoreElements()) {
            WakeupCondition wakeup = (WakeupCondition)behEnum.nextElement();
            if (wakeup instanceof WakeupOnBehaviorPost) {
                hadPost = true;
                continue;
            }
            if (!(wakeup instanceof WakeupOnElapsedFrames)) continue;
            AWTEvent[] events = null;
            ArrayList arrayList = this.eventQueue;
            synchronized (arrayList) {
                events = this.eventQueue.toArray(new AWTEvent[this.eventQueue.size()]);
                this.eventQueue.clear();
            }
            this.processAWTEvents(events);
            if (!this.motion) continue;
            this.integrateTransforms();
        }
        if (this.motion || hadPost) {
            this.wakeupOn((WakeupCondition)this.frameWakeup);
        } else {
            this.wakeupOn((WakeupCondition)this.postWakeup);
        }
    }

    public void setEnable(boolean state) {
        if (state == this.getEnable()) {
            return;
        }
        super.setEnable(state);
        if (this.canvases != null) {
            this.enableListeners(state);
        }
    }

    private void enableListeners(boolean enable) {
        block16: {
            int i;
            block15: {
                int i2;
                if (!enable) break block15;
                this.firstEvent = true;
                if ((this.listenerFlags & 1) != 0) {
                    for (i2 = 0; i2 < this.canvases.length; ++i2) {
                        this.canvases[i2].addMouseListener((MouseListener)this);
                    }
                }
                if ((this.listenerFlags & 2) != 0) {
                    for (i2 = 0; i2 < this.canvases.length; ++i2) {
                        this.canvases[i2].addMouseMotionListener((MouseMotionListener)this);
                    }
                }
                if ((this.listenerFlags & 8) != 0) {
                    for (i2 = 0; i2 < this.canvases.length; ++i2) {
                        this.canvases[i2].addMouseWheelListener((MouseWheelListener)this);
                    }
                }
                if ((this.listenerFlags & 4) == 0) break block16;
                for (i2 = 0; i2 < this.canvases.length; ++i2) {
                    this.canvases[i2].addKeyListener((KeyListener)this);
                }
                break block16;
            }
            if ((this.listenerFlags & 1) != 0) {
                for (i = 0; i < this.canvases.length; ++i) {
                    this.canvases[i].removeMouseListener((MouseListener)this);
                }
            }
            if ((this.listenerFlags & 2) != 0) {
                for (i = 0; i < this.canvases.length; ++i) {
                    this.canvases[i].removeMouseMotionListener((MouseMotionListener)this);
                }
            }
            if ((this.listenerFlags & 8) != 0) {
                for (i = 0; i < this.canvases.length; ++i) {
                    this.canvases[i].removeMouseWheelListener((MouseWheelListener)this);
                }
            }
            if ((this.listenerFlags & 4) != 0) {
                for (i = 0; i < this.canvases.length; ++i) {
                    this.canvases[i].removeKeyListener((KeyListener)this);
                }
            }
        }
    }

    @Override
    public void setViewingPlatform(ViewingPlatform vp) {
        super.setViewingPlatform(vp);
        if (vp == null) {
            this.enableListeners(false);
        } else {
            Viewer[] viewers;
            if (this.canvases != null) {
                this.enableListeners(false);
            }
            if ((viewers = vp.getViewers()) != null && viewers[0] != null) {
                this.canvases = viewers[0].getCanvas3Ds();
            }
            if (this.canvases == null || this.canvases[0] == null) {
                throw new IllegalStateException("No canvases available");
            }
            if (this.getEnable()) {
                this.enableListeners(true);
            }
        }
    }

    protected abstract void processAWTEvents(AWTEvent[] var1);

    protected abstract void integrateTransforms();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueAWTEvent(AWTEvent e) {
        ArrayList arrayList = this.eventQueue;
        synchronized (arrayList) {
            this.eventQueue.add(e);
            if (this.firstEvent || this.eventQueue.size() == 1) {
                this.firstEvent = false;
                this.postId(9998);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.queueAWTEvent(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.queueAWTEvent(e);
    }
}

