/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Numerics;
import com.sun.j3d.utils.geometry.Triangulator;

class BottleNeck {
    BottleNeck() {
    }

    static boolean checkArea(Triangulator triRef, int ind4, int ind5) {
        int i2;
        int ind2;
        double area = 0.0;
        double area1 = 0.0;
        double area2 = 0.0;
        int i0 = triRef.fetchData(ind4);
        int ind1 = triRef.fetchNextData(ind4);
        int i1 = triRef.fetchData(ind1);
        while (ind1 != ind5) {
            ind2 = triRef.fetchNextData(ind1);
            i2 = triRef.fetchData(ind2);
            area = Numerics.stableDet2D(triRef, i0, i1, i2);
            area1 += area;
            ind1 = ind2;
            i1 = i2;
        }
        if (Numerics.le(area1, 1.0E-8)) {
            return false;
        }
        ind1 = triRef.fetchNextData(ind5);
        i1 = triRef.fetchData(ind1);
        while (ind1 != ind4) {
            ind2 = triRef.fetchNextData(ind1);
            i2 = triRef.fetchData(ind2);
            area = Numerics.stableDet2D(triRef, i0, i1, i2);
            area2 += area;
            ind1 = ind2;
            i1 = i2;
        }
        return !Numerics.le(area2, 1.0E-8);
    }

    static boolean checkBottleNeck(Triangulator triRef, int i1, int i2, int i3, int ind4) {
        boolean flag;
        int i4 = i1;
        int ind5 = triRef.fetchPrevData(ind4);
        int i5 = triRef.fetchData(ind5);
        if (i5 != i2 && i5 != i3 && (flag = Numerics.pntInTriangle(triRef, i1, i2, i3, i5))) {
            return true;
        }
        flag = i2 <= i3 ? (i4 <= i5 ? Numerics.segIntersect(triRef, i2, i3, i4, i5, -1) : Numerics.segIntersect(triRef, i2, i3, i5, i4, -1)) : (i4 <= i5 ? Numerics.segIntersect(triRef, i3, i2, i4, i5, -1) : Numerics.segIntersect(triRef, i3, i2, i5, i4, -1));
        if (flag) {
            return true;
        }
        ind5 = triRef.fetchNextData(ind4);
        i5 = triRef.fetchData(ind5);
        if (i5 != i2 && i5 != i3 && (flag = Numerics.pntInTriangle(triRef, i1, i2, i3, i5))) {
            return true;
        }
        flag = i2 <= i3 ? (i4 <= i5 ? Numerics.segIntersect(triRef, i2, i3, i4, i5, -1) : Numerics.segIntersect(triRef, i2, i3, i5, i4, -1)) : (i4 <= i5 ? Numerics.segIntersect(triRef, i3, i2, i4, i5, -1) : Numerics.segIntersect(triRef, i3, i2, i5, i4, -1));
        if (flag) {
            return true;
        }
        ind5 = triRef.fetchNextData(ind4);
        i5 = triRef.fetchData(ind5);
        while (ind5 != ind4) {
            if (i4 == i5 && BottleNeck.checkArea(triRef, ind4, ind5)) {
                return true;
            }
            ind5 = triRef.fetchNextData(ind5);
            i5 = triRef.fetchData(ind5);
        }
        return false;
    }
}

