/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.utils.geometry.compression.CompressedGeometryData;

class CompressedGeometryRetained {
    private static final int HEADER_LENGTH = 48;
    private static final int HEADER_MAJOR_VERSION_OFFSET = 0;
    private static final int HEADER_MINOR_VERSION_OFFSET = 1;
    private static final int HEADER_MINOR_MINOR_VERSION_OFFSET = 2;
    private static final int HEADER_BUFFER_TYPE_OFFSET = 3;
    private static final int HEADER_BUFFER_DATA_OFFSET = 4;
    static final byte TYPE_POINT = 1;
    static final byte TYPE_LINE = 2;
    static final byte TYPE_TRIANGLE = 4;
    int majorVersionNumber;
    int minorVersionNumber;
    int minorMinorVersionNumber;
    int packedVersion;
    int bufferType;
    int bufferContents;
    int renderFlags;
    int offset;
    int size;
    byte[] compressedGeometry;
    private byte[] originalCompressedGeometry = null;
    private boolean byReference = false;

    CompressedGeometryRetained() {
    }

    boolean isByReference() {
        return this.byReference;
    }

    private void createByCopy(byte[] geometry) {
        this.compressedGeometry = new byte[48 + this.size];
        this.compressedGeometry[0] = (byte)this.majorVersionNumber;
        this.compressedGeometry[1] = (byte)this.minorVersionNumber;
        this.compressedGeometry[2] = (byte)this.minorMinorVersionNumber;
        this.compressedGeometry[3] = (byte)this.bufferType;
        this.compressedGeometry[4] = (byte)this.bufferContents;
        System.arraycopy(geometry, this.offset, this.compressedGeometry, 48, this.size);
        this.offset = 48;
    }

    void createCompressedGeometry(CompressedGeometryData.Header hdr, byte[] geometry, boolean byReference) {
        this.byReference = byReference;
        this.majorVersionNumber = hdr.majorVersionNumber;
        this.minorVersionNumber = hdr.minorVersionNumber;
        this.minorMinorVersionNumber = hdr.minorMinorVersionNumber;
        this.packedVersion = hdr.majorVersionNumber << 24 | hdr.minorVersionNumber << 16 | hdr.minorMinorVersionNumber << 8;
        switch (hdr.bufferType) {
            case 0: {
                this.bufferType = 1;
                break;
            }
            case 1: {
                this.bufferType = 2;
                break;
            }
            case 2: {
                this.bufferType = 4;
            }
        }
        this.bufferContents = hdr.bufferDataPresent;
        this.renderFlags = 0;
        this.size = hdr.size;
        this.offset = hdr.start;
        if (byReference) {
            this.compressedGeometry = geometry;
            this.originalCompressedGeometry = geometry;
        } else {
            this.createByCopy(geometry);
            this.originalCompressedGeometry = null;
        }
    }

    int getVertexFormat() {
        int vertexFormat = 1;
        if ((this.bufferContents & 1) != 0) {
            vertexFormat |= 2;
        }
        if ((this.bufferContents & 2) != 0) {
            vertexFormat = (this.bufferContents & 4) != 0 ? (vertexFormat |= 0xC) : (vertexFormat |= 4);
        }
        return vertexFormat;
    }

    int getBufferType() {
        switch (this.bufferType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 2;
    }

    void copy(byte[] buff) {
        System.arraycopy(this.compressedGeometry, this.offset, buff, 0, this.size);
    }

    byte[] getReference() {
        return this.originalCompressedGeometry;
    }
}

