/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;

public class Text2DState
extends LeafState {
    private String text;
    private Color3f color;
    private String fontName;
    private int fontSize;
    private int fontStyle;

    public Text2DState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            Text2D t = (Text2D)this.node;
            this.text = t.getString();
            this.color = t.getColor();
            this.fontName = t.getFontName();
            this.fontSize = t.getFontSize();
            this.fontStyle = t.getFontStyle();
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.control.writeBounds(out, ((Shape3D)this.node).getCollisionBounds());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Shape3D)this.node).setCollisionBounds(this.control.readBounds(in));
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeUTF(this.text);
        this.control.writeColor3f(out, this.color);
        out.writeUTF(this.fontName);
        out.writeInt(this.fontSize);
        out.writeInt(this.fontStyle);
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.text = in.readUTF();
        this.color = this.control.readColor3f(in);
        this.fontName = in.readUTF();
        this.fontSize = in.readInt();
        this.fontStyle = in.readInt();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        Text2D text2D = (Text2D)this.createNode(j3dClass, new Class[]{String.class, Color3f.class, String.class, Integer.TYPE, Integer.TYPE}, new Object[]{this.text, this.color, this.fontName, new Integer(this.fontSize), new Integer(this.fontStyle)});
        return text2D;
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Text2D(this.text, this.color, this.fontName, this.fontSize, this.fontStyle);
    }
}

