/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.UnresolvedBehavior;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.SceneGraphObject;

public class BehaviorState
extends LeafState {
    private int boundingLeaf;

    public BehaviorState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    protected SceneGraphObject createNode(String className) {
        Object ret;
        try {
            ret = super.createNode(className);
        }
        catch (SGIORuntimeException e) {
            ret = new UnresolvedBehavior();
        }
        return ret;
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        Behavior beh = (Behavior)this.node;
        out.writeBoolean(beh.getEnable());
        out.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)beh.getSchedulingBoundingLeaf()));
        this.control.writeBounds(out, beh.getSchedulingBounds());
        out.writeInt(beh.getSchedulingInterval());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        Behavior beh = (Behavior)this.node;
        beh.setEnable(in.readBoolean());
        this.boundingLeaf = in.readInt();
        beh.setSchedulingBounds(this.control.readBounds(in));
        beh.setSchedulingInterval(in.readInt());
    }

    @Override
    public void buildGraph() {
        ((Behavior)this.node).setSchedulingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        super.buildGraph();
    }
}

