/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.PointSoundState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.ConeSound;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Vector3f;

public class ConeSoundState
extends PointSoundState {
    public ConeSoundState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        float[] distanceAtten = new float[((ConeSound)this.node).getAngularAttenuationLength()];
        float[] gainAtten = new float[distanceAtten.length];
        float[] filterAtten = new float[distanceAtten.length];
        float[] backDistance = new float[distanceAtten.length];
        float[] backGain = new float[distanceAtten.length];
        float[] frontDistance = new float[distanceAtten.length];
        float[] frontGain = new float[distanceAtten.length];
        ((ConeSound)this.node).getDistanceGain(frontDistance, frontGain, backDistance, backGain);
        ((ConeSound)this.node).getAngularAttenuation(distanceAtten, gainAtten, filterAtten);
        out.writeInt(distanceAtten.length);
        for (int i = 0; i < distanceAtten.length; ++i) {
            out.writeFloat(distanceAtten[i]);
            out.writeFloat(gainAtten[i]);
            out.writeFloat(filterAtten[i]);
            out.writeFloat(backDistance[i]);
            out.writeFloat(backGain[i]);
        }
        Vector3f direction = new Vector3f();
        ((ConeSound)this.node).getDirection(direction);
        this.control.writeVector3f(out, direction);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        float[] distanceAtten = new float[in.readInt()];
        float[] gainAtten = new float[distanceAtten.length];
        float[] filterAtten = new float[distanceAtten.length];
        float[] backDistance = new float[distanceAtten.length];
        float[] backGain = new float[distanceAtten.length];
        for (int i = 0; i < distanceAtten.length; ++i) {
            distanceAtten[i] = in.readFloat();
            gainAtten[i] = in.readFloat();
            filterAtten[i] = in.readFloat();
            backDistance[i] = in.readFloat();
            backGain[i] = in.readFloat();
        }
        ((ConeSound)this.node).setBackDistanceGain(backDistance, backGain);
        ((ConeSound)this.node).setAngularAttenuation(distanceAtten, gainAtten, filterAtten);
        ((ConeSound)this.node).setDirection(this.control.readVector3f(in));
    }

    @Override
    protected SceneGraphObject createNode() {
        return new ConeSound();
    }
}

