/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.scijava.java3d.Behavior;
import org.scijava.java3d.Node;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.loaders.IncorrectFormatException;
import org.scijava.java3d.loaders.ParsingErrorException;
import org.scijava.java3d.loaders.lw3d.EnvelopeHandler;
import org.scijava.java3d.loaders.lw3d.J3dLwoParser;
import org.scijava.java3d.loaders.lw3d.Lw3dLoader;
import org.scijava.java3d.loaders.lw3d.LwsFrame;
import org.scijava.java3d.loaders.lw3d.LwsMotion;
import org.scijava.java3d.loaders.lw3d.LwsPrimitive;
import org.scijava.java3d.loaders.lw3d.SequenceReader;
import org.scijava.java3d.loaders.lw3d.TextfileParser;
import org.scijava.vecmath.Matrix4d;
import org.scijava.vecmath.Vector3f;

class LwsObject
extends TextfileParser
implements LwsPrimitive {
    String fileName;
    String objName;
    LwsMotion motion;
    int parent;
    TransformGroup objectTransform;
    Vector objectBehavior;
    Vector shapeList = null;
    boolean hasPivot = false;
    TransformGroup pivotTransGroup = null;
    URL urlName;
    String protocol;
    int fileType;

    LwsObject(StreamTokenizer st, boolean loadObject, int firstFrame, int totalFrames, float totalTime, Lw3dLoader loader, int debugVals) throws FileNotFoundException, ParsingErrorException {
        this.debugPrinter.setValidOutput(debugVals);
        this.parent = -1;
        this.fileType = loader.getFileType();
        try {
            if (loadObject) {
                this.fileName = this.getString(st);
                String path = null;
                switch (loader.getFileType()) {
                    case 2: {
                        path = loader.getBasePath();
                        if (path == null) {
                            path = loader.getInternalBasePath();
                        }
                        if (path == null) break;
                        this.fileName = this.getQualifiedFilename(path, this.fileName);
                        break;
                    }
                    case 1: {
                        path = "";
                        URL pathUrl = loader.getBaseUrl();
                        if (pathUrl != null) {
                            path = pathUrl.toString();
                            this.protocol = pathUrl.getProtocol();
                        } else {
                            path = loader.getInternalBaseUrl();
                            this.protocol = new URL(path).getProtocol();
                        }
                        this.urlName = this.getQualifiedURL(path, this.fileName);
                    }
                }
            } else {
                this.objName = this.getString(st);
            }
            this.skip(st, "ShowObject", 2);
            this.debugOutputLn(8, "skipped showobject, about to get objectmotion");
            this.getAndCheckString(st, "ObjectMotion");
            this.debugOutputLn(8, "got string " + st.sval);
            this.motion = new LwsMotion(st, firstFrame, totalFrames, totalTime, debugVals);
            this.debugOutputLn(8, "got motion");
            boolean hasParent = false;
            while (!this.isCurrentToken(st, "ShadowOptions")) {
                if (!hasParent && this.isCurrentToken(st, "ParentObject")) {
                    this.parent = (int)this.getNumber(st);
                    hasParent = true;
                } else if (this.isCurrentToken(st, "PivotPoint")) {
                    this.hasPivot = true;
                    float x = (float)this.getNumber(st);
                    float y = (float)this.getNumber(st);
                    float z = (float)this.getNumber(st);
                    Vector3f pivotPoint = new Vector3f(-x, -y, z);
                    Transform3D pivotTransform = new Transform3D();
                    pivotTransform.set(pivotPoint);
                    this.pivotTransGroup = new TransformGroup(pivotTransform);
                    this.pivotTransGroup.setCapability(18);
                } else if (this.isCurrentToken(st, "ObjDissolve")) {
                    EnvelopeHandler env = new EnvelopeHandler(st, totalFrames, totalTime);
                }
                st.nextToken();
            }
            this.getNumber(st);
            this.debugOutputLn(8, "done with LwsObject constructor");
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
        catch (NumberFormatException e) {
            throw new ParsingErrorException("Expected a number, got " + e.getMessage());
        }
    }

    String getQualifiedFilename(String pathname, String filename) throws FileNotFoundException {
        String pathname2 = "";
        if (filename.indexOf(File.separator) == 0) {
            int index = filename.lastIndexOf(File.separator);
            if (index != -1) {
                pathname2 = filename.substring(0, index + 1);
                filename = filename.substring(index + 1);
            } else {
                return null;
            }
        }
        try {
            if (new File(pathname2 + filename).exists()) {
                return pathname2 + filename;
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        if (new File(pathname2 + filename.toLowerCase()).exists()) {
            return pathname2 + filename.toLowerCase();
        }
        if (new File(pathname + filename).exists()) {
            return pathname + filename;
        }
        if (new File(pathname + filename.toLowerCase()).exists()) {
            return pathname + filename.toLowerCase();
        }
        if (new File(filename).exists()) {
            return filename;
        }
        if (new File(filename.toLowerCase()).exists()) {
            return filename.toLowerCase();
        }
        if (pathname.equals(File.separator) || pathname == null || pathname.equals("")) {
            throw new FileNotFoundException(filename);
        }
        StringBuffer newPathName = new StringBuffer(128);
        StringTokenizer st = new StringTokenizer(pathname, File.separator);
        int tokenCount = st.countTokens() - 1;
        if (pathname.startsWith(File.separator)) {
            newPathName.append(File.separator);
        }
        for (int i = 0; i < tokenCount; ++i) {
            String directory = st.nextToken();
            newPathName.append(directory);
            newPathName.append(File.separator);
        }
        String newPath = newPathName.toString();
        return this.getQualifiedFilename(newPath, filename);
    }

    URL getQualifiedURL(String path, String file) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(path + file);
            url.getContent();
            return url;
        }
        catch (IOException e) {
            try {
                url = new URL(file);
                url.getContent();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                url = new URL(this.protocol + ":" + file);
                url.getContent();
                return url;
            }
            catch (IOException ex) {
                throw new MalformedURLException(path + file);
            }
        }
    }

    int getParent() {
        return this.parent;
    }

    void addChild(LwsPrimitive child) {
        this.debugOutputLn(1, "addChild()");
        if (this.objectTransform != null) {
            this.debugOutputLn(8, "objectTransform = " + this.objectTransform);
            if (child.getObjectNode() != null) {
                this.debugOutputLn(8, "child has object node");
                if (this.hasPivot) {
                    this.pivotTransGroup.addChild((Node)child.getObjectNode());
                } else {
                    this.objectTransform.addChild((Node)child.getObjectNode());
                }
            }
        }
    }

    void createJava3dObject(LwsObject cloneObject, int loadBehaviors) throws IncorrectFormatException, ParsingErrorException, FileNotFoundException {
        String seqToken = new String("_sequence_");
        Matrix4d mat = new Matrix4d();
        mat.setIdentity();
        LwsFrame firstFrame = this.motion.getFirstFrame();
        firstFrame.setMatrix(mat);
        Transform3D t1 = new Transform3D();
        t1.set(mat);
        this.objectTransform = new TransformGroup(t1);
        this.objectTransform.setCapability(18);
        if (this.fileName != null && this.fileName.indexOf(seqToken) != -1) {
            int index = this.fileName.indexOf(seqToken);
            String seqFilename = this.fileName.substring(index += seqToken.length());
            int endIndex = seqFilename.indexOf(".lwo");
            if (endIndex != -1) {
                seqFilename = seqFilename.substring(0, endIndex);
            }
            if (new File(seqFilename).exists()) {
                SequenceReader sr = new SequenceReader(seqFilename, this.motion.totalTime, this.motion.totalFrames);
                sr.printLines();
                sr.createJava3dObjects(this.debugPrinter.getValidOutput(), loadBehaviors);
                TransformGroup g = sr.getObjectNode();
                if (g != null) {
                    this.objectTransform.addChild((Node)g);
                }
                this.objectBehavior = sr.getObjectBehaviors();
                return;
            }
        }
        if (this.fileName != null || this.urlName != null) {
            Enumeration e;
            if (cloneObject == null) {
                this.debugOutputLn(2, "About to load binary file for " + this.fileName);
                J3dLwoParser objParser = null;
                switch (this.fileType) {
                    case 2: {
                        objParser = new J3dLwoParser(this.fileName, this.debugPrinter.getValidOutput());
                        break;
                    }
                    case 1: {
                        objParser = new J3dLwoParser(this.urlName, this.debugPrinter.getValidOutput());
                    }
                }
                objParser.createJava3dGeometry();
                if (this.hasPivot) {
                    this.objectTransform.addChild((Node)this.pivotTransGroup);
                }
                if (objParser.getJava3dShapeList() != null) {
                    this.shapeList = objParser.getJava3dShapeList();
                    e = this.shapeList.elements();
                    while (e.hasMoreElements()) {
                        if (!this.hasPivot || this.pivotTransGroup == null) {
                            this.objectTransform.addChild((Node)((Shape3D)e.nextElement()));
                            continue;
                        }
                        this.pivotTransGroup.addChild((Node)((Shape3D)e.nextElement()));
                    }
                }
            } else {
                this.debugOutputLn(8, "Cloning shapes");
                Vector cloneShapeList = cloneObject.getShapeList();
                e = cloneShapeList.elements();
                while (e.hasMoreElements()) {
                    this.debugOutputLn(8, "   shape clone");
                    Shape3D shape = (Shape3D)e.nextElement();
                    Shape3D cloneShape = (Shape3D)shape.cloneTree();
                    this.objectTransform.addChild((Node)cloneShape);
                }
            }
        }
        this.objectBehavior = new Vector();
        if (loadBehaviors != 0) {
            this.motion.createJava3dBehaviors(this.objectTransform);
            Behavior b = this.motion.getBehaviors();
            if (b != null) {
                this.objectBehavior.addElement(b);
            }
        }
    }

    Vector getShapeList() {
        return this.shapeList;
    }

    @Override
    public TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    @Override
    public Vector getObjectBehaviors() {
        this.debugOutputLn(1, "getObjectBehaviors()");
        return this.objectBehavior;
    }

    void printVals() {
        this.debugOutputLn(2, "  OBJECT vals: ");
        this.debugOutputLn(2, "   fileName = " + this.fileName);
        this.debugOutputLn(2, "   objName = " + this.objName);
        this.motion.printVals();
    }
}

