/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.Node;
import org.scijava.java3d.Switch;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.loaders.ParsingErrorException;
import org.scijava.java3d.loaders.lw3d.SequenceLine;
import org.scijava.java3d.loaders.lw3d.SwitchPathInterpolator;
import org.scijava.vecmath.Point3d;

class SequenceReader {
    Vector sequenceLines;
    float totalTime;
    int totalFrames;
    TransformGroup objectTransform;
    Vector behaviorVector;

    SequenceReader(String filename, float time, int frames) throws ParsingErrorException {
        this.totalTime = time;
        this.totalFrames = frames;
        this.sequenceLines = new Vector();
        try {
            StreamTokenizer st = new StreamTokenizer(new BufferedReader(new FileReader(filename)));
            st.wordChars(95, 95);
            st.wordChars(47, 47);
            int type = st.nextToken();
            while (st.ttype != -1) {
                this.sequenceLines.addElement(new SequenceLine(st, this.totalTime, this.totalFrames));
                st.nextToken();
            }
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
    }

    void createJava3dObjects(int debugVals, int loadBehaviors) throws FileNotFoundException {
        this.objectTransform = new TransformGroup();
        this.behaviorVector = new Vector();
        Enumeration e = this.sequenceLines.elements();
        Switch switchNode = new Switch();
        switchNode.setCapability(17);
        switchNode.setCapability(18);
        this.objectTransform.addChild((Node)switchNode);
        while (e.hasMoreElements()) {
            SequenceLine line = (SequenceLine)e.nextElement();
            line.createJava3dObjects(debugVals, loadBehaviors);
            if (line.getGeometry() != null) {
                switchNode.addChild((Node)line.getGeometry());
            }
            if (line.getBehavior() == null) continue;
            this.behaviorVector.addElement(line.getBehavior());
        }
        float[] knots = new float[this.sequenceLines.size() + 1];
        for (int i = 0; i < knots.length - 1; ++i) {
            SequenceLine sl = (SequenceLine)this.sequenceLines.elementAt(i);
            knots[i] = (float)sl.startFrame / (float)this.totalFrames;
        }
        knots[knots.length - 1] = 1.0f;
        Alpha theAlpha = new Alpha(-1, 1, 0L, 0L, (long)(1000.0f * this.totalTime), 0L, 0L, 0L, 0L, 0L);
        SwitchPathInterpolator switchPath = new SwitchPathInterpolator(theAlpha, knots, switchNode);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
        switchPath.setSchedulingBounds((Bounds)bounds);
        switchNode.addChild((Node)switchPath);
        this.behaviorVector.addElement(switchPath);
    }

    TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    Vector getObjectBehaviors() {
        return this.behaviorVector;
    }

    void printLines() {
        Enumeration e = this.sequenceLines.elements();
        while (e.hasMoreElements()) {
            SequenceLine sequenceLine = (SequenceLine)e.nextElement();
        }
    }
}

