/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry;

import org.scijava.java3d.Appearance;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.Node;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.utils.geometry.GeomBuffer;
import org.scijava.java3d.utils.geometry.Primitive;
import org.scijava.vecmath.Vector3f;

public class Box
extends Primitive {
    public static final int FRONT = 0;
    public static final int BACK = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    float xDim;
    float yDim;
    float zDim;
    int numTexUnit = 1;
    private static final float[] verts = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
    private static final double[] tcoords = new double[]{1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0};
    private static final Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};

    public Box() {
        this(1.0f, 1.0f, 1.0f, 1, null);
    }

    public Box(float xdim, float ydim, float zdim, Appearance ap) {
        this(xdim, ydim, zdim, 1, ap);
    }

    public Box(float xdim, float ydim, float zdim, int primflags, Appearance ap, int numTexUnit) {
        this.xDim = xdim;
        this.yDim = ydim;
        this.zDim = zdim;
        this.flags = primflags;
        this.numTexUnit = numTexUnit;
        boolean texCoordYUp = (this.flags & 8) != 0;
        double sign = (this.flags & 4) != 0 ? -1.0 : 1.0;
        Shape3D[] shape = new Shape3D[6];
        GeomBuffer cache = null;
        for (int i = 0; i <= 5; ++i) {
            cache = this.getCachedGeometry(8, xdim, ydim, zdim, i, i, primflags);
            if (cache != null) {
                shape[i] = new Shape3D((Geometry)cache.getComputedGeometry());
                this.numVerts += cache.getNumVerts();
                this.numTris += cache.getNumTris();
            } else {
                int j;
                GeomBuffer gbuf = new GeomBuffer(4, numTexUnit);
                gbuf.begin(1);
                for (j = 0; j < 2; ++j) {
                    gbuf.normal3d((double)Box.normals[i].x * sign, (double)Box.normals[i].y * sign, (double)Box.normals[i].z * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(tcoords[i * 8 + j * 2], 1.0 - tcoords[i * 8 + j * 2 + 1]);
                    } else {
                        gbuf.texCoord2d(tcoords[i * 8 + j * 2], tcoords[i * 8 + j * 2 + 1]);
                    }
                    gbuf.vertex3d((double)verts[i * 12 + j * 3] * (double)xdim, (double)verts[i * 12 + j * 3 + 1] * (double)ydim, (double)verts[i * 12 + j * 3 + 2] * (double)zdim);
                }
                for (j = 3; j > 1; --j) {
                    gbuf.normal3d((double)Box.normals[i].x * sign, (double)Box.normals[i].y * sign, (double)Box.normals[i].z * sign);
                    if (texCoordYUp) {
                        gbuf.texCoord2d(tcoords[i * 8 + j * 2], 1.0 - tcoords[i * 8 + j * 2 + 1]);
                    } else {
                        gbuf.texCoord2d(tcoords[i * 8 + j * 2], tcoords[i * 8 + j * 2 + 1]);
                    }
                    gbuf.vertex3d((double)verts[i * 12 + j * 3] * (double)xdim, (double)verts[i * 12 + j * 3 + 1] * (double)ydim, (double)verts[i * 12 + j * 3 + 2] * (double)zdim);
                }
                gbuf.end();
                shape[i] = new Shape3D((Geometry)gbuf.getGeom(this.flags));
                this.numVerts = gbuf.getNumVerts();
                this.numTris = gbuf.getNumTris();
                if ((primflags & 0x10) == 0) {
                    this.cacheGeometry(8, xdim, ydim, zdim, i, i, primflags, gbuf);
                }
            }
            if ((this.flags & 0x40) != 0) {
                shape[i].setCapability(14);
                shape[i].setCapability(15);
            }
            if ((this.flags & 0x20) != 0) {
                shape[i].setCapability(12);
            }
            this.addChild((Node)shape[i]);
        }
        if (ap == null) {
            this.setAppearance();
        } else {
            this.setAppearance(ap);
        }
    }

    public Box(float xdim, float ydim, float zdim, int primflags, Appearance ap) {
        this(xdim, ydim, zdim, primflags, ap, 1);
    }

    @Override
    public Shape3D getShape(int partId) {
        if (partId >= 0 && partId <= 5) {
            return (Shape3D)this.getChild(partId);
        }
        return null;
    }

    @Override
    public void setAppearance(Appearance ap) {
        ((Shape3D)this.getChild(4)).setAppearance(ap);
        ((Shape3D)this.getChild(3)).setAppearance(ap);
        ((Shape3D)this.getChild(2)).setAppearance(ap);
        ((Shape3D)this.getChild(0)).setAppearance(ap);
        ((Shape3D)this.getChild(1)).setAppearance(ap);
        ((Shape3D)this.getChild(5)).setAppearance(ap);
    }

    @Override
    public Appearance getAppearance(int partId) {
        if (partId > 5 || partId < 0) {
            return null;
        }
        return this.getShape(partId).getAppearance();
    }

    public Node cloneNode(boolean forceDuplicate) {
        Box b = new Box(this.xDim, this.yDim, this.zDim, this.flags, this.getAppearance());
        b.duplicateNode((Node)this, forceDuplicate);
        return b;
    }

    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        super.duplicateNode(originalNode, forceDuplicate);
    }

    public float getXdimension() {
        return this.xDim;
    }

    public float getYdimension() {
        return this.yDim;
    }

    public float getZdimension() {
        return this.zDim;
    }
}

