/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry.compression;

import org.scijava.java3d.utils.geometry.compression.CommandStream;
import org.scijava.java3d.utils.geometry.compression.CompressionStream;
import org.scijava.java3d.utils.geometry.compression.CompressionStreamElement;
import org.scijava.java3d.utils.geometry.compression.HuffmanNode;
import org.scijava.java3d.utils.geometry.compression.HuffmanTable;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4f;

class CompressionStreamColor
extends CompressionStreamElement {
    private int R;
    private int G;
    private int B;
    private int A;
    private boolean color3;
    private boolean color4;
    private float colorR;
    private float colorG;
    private float colorB;
    private float colorA;
    int rAbsolute;
    int gAbsolute;
    int bAbsolute;
    int aAbsolute;

    CompressionStreamColor(CompressionStream stream, Color3f c3) {
        this.color4 = false;
        this.color3 = true;
        this.colorR = c3.x;
        this.colorG = c3.y;
        this.colorB = c3.z;
        this.colorA = 0.0f;
        stream.byteCount += 12;
    }

    CompressionStreamColor(CompressionStream stream, Color4f c4) {
        this.color3 = false;
        this.color4 = true;
        this.colorR = c4.x;
        this.colorG = c4.y;
        this.colorB = c4.z;
        this.colorA = c4.w;
        stream.byteCount += 16;
    }

    @Override
    void quantize(CompressionStream stream, HuffmanTable huffmanTable) {
        int quant = stream.colorQuant < 2 ? 2 : (stream.colorQuant > 16 ? 16 : stream.colorQuant);
        this.absolute = false;
        if (stream.firstColor || stream.colorQuantChanged) {
            this.absolute = true;
            stream.lastColor[0] = 0;
            stream.lastColor[1] = 0;
            stream.lastColor[2] = 0;
            stream.lastColor[3] = 0;
            stream.firstColor = false;
            stream.colorQuantChanged = false;
        }
        if (this.color3) {
            this.R = (int)((double)this.colorR * 32768.0);
            this.G = (int)((double)this.colorG * 32768.0);
            this.B = (int)((double)this.colorB * 32768.0);
            this.A = 0;
        } else if (this.color4) {
            this.R = (int)((double)this.colorR * 32768.0);
            this.G = (int)((double)this.colorG * 32768.0);
            this.B = (int)((double)this.colorB * 32768.0);
            this.A = (int)((double)this.colorA * 32768.0);
        }
        int n = this.R > Short.MAX_VALUE ? Short.MAX_VALUE : (this.R = this.R < 0 ? 0 : this.R);
        int n2 = this.G > Short.MAX_VALUE ? Short.MAX_VALUE : (this.G = this.G < 0 ? 0 : this.G);
        int n3 = this.B > Short.MAX_VALUE ? Short.MAX_VALUE : (this.B = this.B < 0 ? 0 : this.B);
        this.A = this.A > Short.MAX_VALUE ? Short.MAX_VALUE : (this.A < 0 ? 0 : this.A);
        this.R &= quantizationMask[quant];
        this.G &= quantizationMask[quant];
        this.B &= quantizationMask[quant];
        this.A &= quantizationMask[quant];
        this.rAbsolute = this.R;
        this.gAbsolute = this.G;
        this.bAbsolute = this.B;
        this.aAbsolute = this.A;
        this.R -= stream.lastColor[0];
        this.G -= stream.lastColor[1];
        this.B -= stream.lastColor[2];
        this.A -= stream.lastColor[3];
        stream.lastColor[0] = stream.lastColor[0] + this.R;
        stream.lastColor[1] = stream.lastColor[1] + this.G;
        stream.lastColor[2] = stream.lastColor[2] + this.B;
        stream.lastColor[3] = stream.lastColor[3] + this.A;
        if (this.color3) {
            this.computeLengthShift(this.R, this.G, this.B);
        } else if (this.color4) {
            this.computeLengthShift(this.R, this.G, this.B, this.A);
        }
        if (this.length == 0) {
            this.length = 1;
        }
        huffmanTable.addColorEntry(this.length, this.shift, this.absolute);
    }

    @Override
    void outputCommand(HuffmanTable table, CommandStream output) {
        this.outputColor(table, output, 128, 8);
    }

    void outputSubcommand(HuffmanTable table, CommandStream output) {
        this.outputColor(table, output, 0, 6);
    }

    private void outputColor(HuffmanTable table, CommandStream output, int header, int headerLength) {
        HuffmanNode t = table.getColorEntry(this.length, this.shift, this.absolute);
        int componentLength = t.dataLength - t.shift;
        int subcommandLength = t.tagLength + 3 * componentLength;
        this.R = this.R >> t.shift & (int)lengthMask[componentLength];
        this.G = this.G >> t.shift & (int)lengthMask[componentLength];
        this.B = this.B >> t.shift & (int)lengthMask[componentLength];
        long colorSubcommand = (long)t.tag << 3 * componentLength | (long)this.R << 2 * componentLength | (long)this.G << 1 * componentLength | (long)this.B << 0 * componentLength;
        if (subcommandLength < 6) {
            header |= (int)(colorSubcommand << 6 - subcommandLength);
            subcommandLength = 0;
        } else {
            header |= (int)(colorSubcommand >>> subcommandLength - 6);
            subcommandLength -= 6;
        }
        if (this.color4) {
            this.A = this.A >> t.shift & (int)lengthMask[componentLength];
            colorSubcommand = colorSubcommand << componentLength | (long)this.A;
            subcommandLength += componentLength;
        }
        output.addCommand(header, headerLength, colorSubcommand, subcommandLength);
    }

    public String toString() {
        String d = this.absolute ? "" : "delta ";
        String c = this.colorR + " " + this.colorG + " " + this.colorB + (this.color4 ? " " + this.colorA : "");
        return "color: " + c + "\n" + " fixed point " + d + this.R + " " + this.G + " " + this.B + "\n" + " length " + this.length + " shift " + this.shift + (this.absolute ? " absolute" : " relative");
    }
}

