/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.retained;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ListIterator;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.UnsupportedUniverseException;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SGIORuntimeException;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTable;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.BranchGroupState;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.SceneGraphObjectState;
import org.scijava.java3d.utils.universe.ConfiguredUniverse;
import org.scijava.java3d.utils.universe.SimpleUniverse;

public class RandomAccessFileControl
extends Controller {
    protected String FILE_IDENT = new String("j3dff");
    private long user_data;
    private long universe_config;
    private long symbol_table;
    private RandomAccessFile raf;
    private int branchGraphCount = 0;
    private boolean writeMode = false;
    private Object userData;

    public RandomAccessFileControl() {
        this.symbolTable = new SymbolTable(this);
    }

    public void createFile(File file, SimpleUniverse universe, boolean writeUniverseContent, String description, Serializable userData) throws IOException, UnsupportedUniverseException, CapabilityNotSetException {
        this.raf = new RandomAccessFile(file, "rw");
        this.writeMode = true;
        this.raf.seek(0L);
        this.raf.writeUTF(this.FILE_IDENT);
        this.raf.seek(20L);
        this.raf.writeInt(this.outputFileVersion);
        this.raf.seek(68L);
        this.raf.writeInt(0);
        this.raf.seek(72L);
        if (description == null) {
            description = "";
        }
        this.raf.writeUTF(description);
        try {
            this.writeSerializedData(this.raf, userData);
            this.universe_config = this.raf.getFilePointer();
            this.writeUniverse(this.raf, universe, writeUniverseContent);
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void openFile(File file) throws IOException {
        this.raf = new RandomAccessFile(file, "r");
        this.writeMode = false;
        this.raf.seek(0L);
        String ident = this.raf.readUTF();
        if (ident.equals("demo_j3f")) {
            throw new IOException("Use Java 3D Fly Through I/O instead of Java 3D Scenegraph I/O");
        }
        if (!ident.equals("j3dff")) {
            throw new IOException("This is a Stream - use SceneGraphStreamReader instead");
        }
        this.raf.seek(20L);
        this.currentFileVersion = this.raf.readInt();
        if (this.currentFileVersion > this.outputFileVersion) {
            throw new IOException("Unsupported file version. This file was written using a new version of the SceneGraph IO API, please update your installtion to the latest version");
        }
        String description = this.readFileDescription();
        this.raf.seek(68L);
        this.branchGraphCount = this.raf.readInt();
        this.raf.seek(60L);
        this.universe_config = this.raf.readLong();
        this.raf.seek(30L);
        this.symbol_table = this.raf.readLong();
        this.raf.seek(this.symbol_table);
        this.symbolTable.readTable(this.raf, false);
        this.raf.seek(this.user_data);
        this.userData = this.readSerializedData(this.raf);
    }

    public ConfiguredUniverse readUniverse(boolean attachBranchGraphs, Canvas3D canvas) throws IOException {
        this.raf.seek(this.universe_config);
        return this.readUniverse(this.raf, attachBranchGraphs, canvas);
    }

    public Object getUserData() {
        return this.userData;
    }

    @Override
    protected void readBranchGraphs(int[] graphs) throws IOException {
        for (int i = 0; i < graphs.length; ++i) {
            this.readBranchGraph(graphs[i]);
        }
    }

    public int getBranchGraphCount() {
        return this.symbolTable.getBranchGraphCount();
    }

    @Override
    public void writeBranchGraph(BranchGroup bg, Serializable userData) throws IOException {
        long filePointer = this.raf.getFilePointer();
        this.raf.writeInt(0);
        try {
            this.writeSerializedData(this.raf, userData);
            SymbolTableData symbol = this.symbolTable.getSymbol((SceneGraphObject)bg);
            if (symbol == null) {
                symbol = this.symbolTable.createSymbol((SceneGraphObject)bg);
                symbol.branchGraphID = -1;
            }
            this.symbolTable.setBranchGraphRoot(symbol, filePointer);
            this.symbolTable.startUnsavedNodeComponentFrame();
            SceneGraphObjectState state = this.createState((SceneGraphObject)bg, symbol);
            try {
                this.writeObject(this.raf, state);
                this.writeNodeComponents(this.raf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.symbolTable.endUnsavedNodeComponentFrame();
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    public BranchGroup[] readBranchGraph(int graphID) throws IOException {
        try {
            int i;
            int[] dependencies = this.symbolTable.getBranchGraphDependencies(graphID);
            BranchGroupState[] states = new BranchGroupState[dependencies.length + 1];
            BranchGroup[] ret = new BranchGroup[states.length];
            states[0] = this.readSingleBranchGraph(graphID);
            for (i = 0; i < dependencies.length; ++i) {
                states[i + 1] = this.readSingleBranchGraph(dependencies[i]);
            }
            for (i = 0; i < states.length; ++i) {
                if (!states[i].getSymbol().graphBuilt) {
                    states[i].buildGraph();
                    states[i].getSymbol().graphBuilt = true;
                }
                ret[i] = (BranchGroup)states[i].getNode();
            }
            this.symbolTable.clearUnshared();
            return ret;
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    public BranchGroup[] readAllBranchGraphs() throws IOException {
        int size = this.getBranchGraphCount();
        BranchGroupState[] states = new BranchGroupState[size];
        BranchGroup[] ret = new BranchGroup[size];
        try {
            int i;
            for (i = 0; i < size; ++i) {
                states[i] = this.readSingleBranchGraph(i);
            }
            for (i = 0; i < states.length; ++i) {
                if (!states[i].getSymbol().graphBuilt) {
                    states[i].buildGraph();
                    states[i].getSymbol().graphBuilt = true;
                }
                ret[i] = (BranchGroup)states[i].getNode();
            }
            this.symbolTable.clearUnshared();
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
        return ret;
    }

    private BranchGroupState readSingleBranchGraph(int graphID) throws IOException {
        SymbolTableData symbol = this.symbolTable.getBranchGraphRoot(graphID);
        if (symbol.nodeState != null) {
            return (BranchGroupState)symbol.nodeState;
        }
        this.raf.seek(this.symbolTable.getBranchGraphFilePosition(graphID));
        return this.readNextBranchGraph();
    }

    private BranchGroupState readNextBranchGraph() throws IOException {
        int nodeCount = this.raf.readInt();
        this.skipUserData(this.raf);
        BranchGroupState state = null;
        try {
            state = (BranchGroupState)this.readObject(this.raf);
            this.readNodeComponents(this.raf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return state;
    }

    public Object readBranchGraphUserData(int graphID) throws IOException {
        try {
            this.raf.seek(this.symbolTable.getBranchGraphFilePosition(graphID));
            int nodeCount = this.raf.readInt();
            return this.readSerializedData(this.raf);
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void writeNodeComponents(DataOutput out) throws IOException {
        long ptrLoc = 0L;
        ListIterator list = this.symbolTable.getUnsavedNodeComponents();
        out.writeInt(this.symbolTable.getUnsavedNodeComponentsSize());
        while (list.hasNext()) {
            SymbolTableData symbol = (SymbolTableData)list.next();
            out.writeInt(symbol.nodeID);
            ptrLoc = this.raf.getFilePointer();
            out.writeLong(0L);
            this.writeObject(out, symbol.getNodeState());
            long ptr = this.raf.getFilePointer();
            this.raf.seek(ptrLoc);
            out.writeLong(ptr);
            this.raf.seek(ptr);
        }
    }

    @Override
    protected void readNodeComponents(DataInput in) throws IOException {
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            int nodeID = in.readInt();
            long nextNC = in.readLong();
            if (this.symbolTable.isLoaded(nodeID)) {
                this.raf.seek(nextNC);
                continue;
            }
            SceneGraphObjectState nodeComponent = this.readObject(in);
        }
    }

    @Override
    public void writeObject(DataOutput out, SceneGraphObjectState obj) throws IOException {
        this.symbolTable.setFilePosition(this.raf.getFilePointer(), obj);
        try {
            super.writeObject(out, obj);
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String readFileDescription() throws IOException {
        this.raf.seek(72L);
        String ret = this.raf.readUTF();
        this.user_data = this.raf.getFilePointer();
        return ret;
    }

    public void loadNodeComponent(SymbolTableData symbol) throws IOException {
        try {
            this.raf.seek(symbol.filePosition);
            this.readObject(this.raf);
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void loadSharedGroup(SymbolTableData symbol) throws IOException {
        try {
            this.raf.seek(symbol.filePosition);
            this.readObject(this.raf);
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.writeMode) {
                this.writeClose();
            }
            this.raf.close();
            super.reset();
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void writeClose() throws IOException {
        this.symbol_table = this.raf.getFilePointer();
        super.getSymbolTable().writeTable(this.raf);
        this.raf.seek(60L);
        this.raf.writeLong(this.universe_config);
        this.raf.seek(30L);
        this.raf.writeLong(this.symbol_table);
        this.raf.seek(68L);
        this.raf.writeInt(this.symbolTable.getBranchGraphCount());
    }

    @Override
    public long getFilePointer() {
        try {
            return this.raf.getFilePointer();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public int getBranchGraphPosition(BranchGroup graph) {
        SymbolTableData symbol = this.symbolTable.getSymbol((SceneGraphObject)graph);
        if (symbol != null) {
            return symbol.branchGraphID;
        }
        return -1;
    }
}

