/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.Behavior;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.UnresolvedBehavior;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SGIORuntimeException;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.LeafState;

public class BehaviorState
extends LeafState {
    private int boundingLeaf;

    public BehaviorState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    protected SceneGraphObject createNode(String className) {
        Object ret;
        try {
            ret = super.createNode(className);
        }
        catch (SGIORuntimeException e) {
            ret = new UnresolvedBehavior();
        }
        return ret;
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        Behavior beh = (Behavior)this.node;
        out.writeBoolean(beh.getEnable());
        out.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)beh.getSchedulingBoundingLeaf()));
        this.control.writeBounds(out, beh.getSchedulingBounds());
        out.writeInt(beh.getSchedulingInterval());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        Behavior beh = (Behavior)this.node;
        beh.setEnable(in.readBoolean());
        this.boundingLeaf = in.readInt();
        beh.setSchedulingBounds(this.control.readBounds(in));
        beh.setSchedulingInterval(in.readInt());
    }

    @Override
    public void buildGraph() {
        ((Behavior)this.node).setSchedulingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        super.buildGraph();
    }
}

