/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.scijava.annotations.legacy.LegacyReader;

class IndexReader {
    private final PushbackInputStream in;

    IndexReader(InputStream in) {
        this.in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(new BufferedInputStream(in));
    }

    public Object next() throws IOException {
        int c = this.in.read();
        if (c < 0) {
            return null;
        }
        if (c == 123) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            do {
                if (this.expect('\"', '}') == 1) {
                    return map;
                }
                String key = this.readString();
                this.expect(':');
                Object value = this.next();
                map.put(key, value);
            } while (this.expect(',', '}') != 1);
            return map;
        }
        if (c == 91) {
            ArrayList<Object> list = new ArrayList<Object>();
            c = this.in.read();
            if (c == 93) {
                return list;
            }
            this.in.unread(c);
            do {
                Object value = this.next();
                list.add(value);
            } while (this.expect(',', ']') != 1);
            return list;
        }
        if (c == 116) {
            this.expect("rue");
            return true;
        }
        if (c == 102) {
            this.expect("alse");
            return false;
        }
        if (c == 110) {
            this.expect("ull");
            throw new IOException("Invalid stream: contains null");
        }
        if (c == 46 || c == 45 || c >= 48 && c <= 57) {
            boolean isInteger = true;
            StringBuilder builder = new StringBuilder();
            while (true) {
                builder.append((char)c);
                c = this.in.read();
                if (c == 46 || c == 101 || c == 69) {
                    isInteger = false;
                    continue;
                }
                if (c < 48 || c > 57) break;
            }
            this.in.unread(c);
            c = this.in.read();
            if (c == 73 && "-".equals(builder.toString())) {
                this.expect("nfinity");
                return Double.NEGATIVE_INFINITY;
            }
            this.in.unread(c);
            if (isInteger) {
                return Long.parseLong(builder.toString());
            }
            return Double.parseDouble(builder.toString());
        }
        if (c == 73) {
            this.expect("nfinity");
            return Double.POSITIVE_INFINITY;
        }
        if (c == 78) {
            this.expect("aN");
            return Double.NaN;
        }
        if (c == 34) {
            return this.readString();
        }
        throw new IOException("Unexpected char: '" + (char)c + "'");
    }

    public void close() throws IOException {
        this.in.close();
    }

    private String readString() throws IOException {
        StringBuilder builder = new StringBuilder();
        int c;
        while ((c = this.in.read()) != 34) {
            builder.append((char)this.readCharacter(c));
        }
        return builder.toString();
    }

    private int readCharacter(int first) throws IOException {
        int c = first;
        if (c == 92) {
            c = this.in.read();
            if (c == 117) {
                String hex = "" + (char)this.in.read() + (char)this.in.read() + (char)this.in.read() + (char)this.in.read();
                c = Integer.parseInt(hex, 16);
            } else if (c != 92 && c != 34) {
                throw new IOException("Expected '\"' or '\\', got '" + c + "'");
            }
        }
        return c;
    }

    private void expect(char expect) throws IOException {
        int c = this.in.read();
        if (c != expect) {
            throw new IOException("Expected '" + expect + "', got '" + (char)c + "'");
        }
    }

    private int expect(char a, char b) throws IOException {
        int c = this.in.read();
        if (c == a) {
            return 0;
        }
        if (c == b) {
            return 1;
        }
        throw new IOException("Expected '" + a + "' or '" + b + "', got '" + (char)c + "'");
    }

    private void expect(String match) throws IOException {
        for (char c : match.toCharArray()) {
            this.expect(c);
        }
    }

    private IndexReader() {
        this.in = null;
    }

    static IndexReader getLegacyReader(InputStream in) throws IOException {
        final LegacyReader legacy = new LegacyReader(in);
        return new IndexReader(){

            @Override
            public Object next() throws IOException {
                return legacy.readObject();
            }

            @Override
            public void close() throws IOException {
                legacy.close();
            }
        };
    }
}

