/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.scijava.annotations.AbstractIndexWriter;
import org.scijava.annotations.Indexable;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"*"})
public class AnnotationProcessor
extends AbstractProcessor {
    private RoundEnvironment roundEnv;

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        this.roundEnv = env;
        Writer writer = new Writer();
        for (TypeElement typeElement : elements) {
            writer.add(typeElement);
        }
        try {
            writer.write(writer);
        }
        catch (IOException e) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(byteArrayOutputStream));
            try {
                byteArrayOutputStream.close();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, byteArrayOutputStream.toString());
            }
            catch (IOException e2) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e2.getMessage() + " while printing " + e.getMessage());
            }
        }
        return false;
    }

    static /* synthetic */ ProcessingEnvironment access$100(AnnotationProcessor x0) {
        return x0.processingEnv;
    }

    static /* synthetic */ ProcessingEnvironment access$200(AnnotationProcessor x0) {
        return x0.processingEnv;
    }

    static /* synthetic */ ProcessingEnvironment access$300(AnnotationProcessor x0) {
        return x0.processingEnv;
    }

    private class Writer
    extends AbstractIndexWriter
    implements AbstractIndexWriter.StreamFactory {
        private final Map<String, List<Element>> originatingElements = new HashMap<String, List<Element>>();
        private final Filer filer = AnnotationProcessor.access$100(AnnotationProcessor.this).getFiler();
        private final Elements utils = AnnotationProcessor.access$200(AnnotationProcessor.this).getElementUtils();
        private final Types typeUtils = AnnotationProcessor.access$300(AnnotationProcessor.this).getTypeUtils();

        private Writer() {
        }

        public void add(TypeElement element) {
            AnnotationMirror mirror = this.getMirror(element);
            if (mirror != null) {
                String annotationName = this.utils.getBinaryName(element).toString();
                List<Element> originating = this.originatingElements.get(annotationName);
                if (originating == null) {
                    originating = new ArrayList<Element>();
                    this.originatingElements.put(annotationName, originating);
                }
                block3: for (Element element2 : AnnotationProcessor.this.roundEnv.getElementsAnnotatedWith(element)) {
                    switch (element2.getKind()) {
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            String className = this.utils.getBinaryName((TypeElement)element2).toString();
                            Map<String, Object> values = this.adapt(element2.getAnnotationMirrors(), element.asType());
                            super.add(values, annotationName, className);
                            originating.add(element2);
                            continue block3;
                        }
                    }
                    AnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot handle annotated element of kind " + (Object)((Object)element2.getKind()));
                }
            }
        }

        private Map<String, Object> adapt(List<? extends AnnotationMirror> mirrors, TypeMirror annotationType) {
            TreeMap<String, Object> result = new TreeMap<String, Object>();
            for (AnnotationMirror annotationMirror : mirrors) {
                if (!this.typeUtils.isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
                return (Map)this.adapt(annotationMirror);
            }
            return result;
        }

        @Override
        protected Object adapt(Object o) {
            if (o instanceof AnnotationMirror) {
                AnnotationMirror mirror = (AnnotationMirror)o;
                TreeMap<String, Object> result = new TreeMap<String, Object>();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
                    String key = entry.getKey().getSimpleName().toString();
                    Object value = this.adapt(entry.getValue().getValue());
                    result.put(key, value);
                }
                return result;
            }
            if (o instanceof List) {
                List list = (List)o;
                ArrayList<Object> result = new ArrayList<Object>(list.size());
                for (Object item : list) {
                    result.add(this.adapt(item));
                }
                return result;
            }
            if (o instanceof TypeMirror) {
                TypeMirror mirror = (TypeMirror)o;
                return this.utils.getBinaryName((TypeElement)this.typeUtils.asElement(mirror)).toString();
            }
            if (o instanceof VariableElement) {
                VariableElement element = (VariableElement)o;
                TreeMap<String, String> result = new TreeMap<String, String>();
                String enumName = this.utils.getBinaryName((TypeElement)element.getEnclosingElement()).toString();
                String valueName = element.getSimpleName().toString();
                result.put("enum", enumName);
                result.put("value", valueName);
                return result;
            }
            return super.adapt(o);
        }

        private AnnotationMirror getMirror(TypeElement element) {
            for (AnnotationMirror annotationMirror : this.utils.getAllAnnotationMirrors(element)) {
                Name binaryName = this.utils.getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement());
                if (!binaryName.contentEquals(Indexable.class.getName())) continue;
                return annotationMirror;
            }
            return null;
        }

        @Override
        public InputStream openInput(String annotationName) throws IOException {
            try {
                return this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/json/" + annotationName).openInputStream();
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        @Override
        public OutputStream openOutput(String annotationName) throws IOException {
            List<Element> originating = this.originatingElements.get(annotationName);
            return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/json/" + annotationName, originating.toArray(new Element[originating.size()])).openOutputStream();
        }

        @Override
        public boolean isClassObsolete(String className) {
            return false;
        }
    }
}

