/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.PrimitiveArray;
import org.scijava.util.PrimitiveArrayTest;
import org.scijava.util.ShortArray;

public class ShortArrayTest
extends PrimitiveArrayTest {
    @Test
    public void testConstructorNoArgs() {
        ShortArray array = new ShortArray();
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)((short[])array.copyArray()).length);
    }

    @Test
    public void testConstructorSize() {
        int size = 24;
        ShortArray array = new ShortArray(24);
        Assert.assertEquals((long)24L, (long)array.size());
        Assert.assertEquals((long)24L, (long)((short[])array.copyArray()).length);
    }

    @Test
    public void testConstructorArray() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
        Assert.assertEquals((long)raw.length, (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertArrayEquals((short[])raw, (short[])((short[])array.copyArray()));
    }

    @Test
    public void testAddValue() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        boolean e6 = true;
        int e7 = 2;
        array.addValue((short)1);
        array.addValue((short)2);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((long)1L, (long)array.getValue(5));
        Assert.assertEquals((long)2L, (long)array.getValue(6));
    }

    public void testRemoveValue() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeValue(raw[0]);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.removeValue(raw[2]);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.removeValue(raw[4]);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    public void testGetValue() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
    }

    @Test
    public void testSetValue() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        int e0 = 7;
        boolean e2 = true;
        int e4 = 2;
        array.setValue(0, (short)7);
        array.setValue(2, (short)1);
        array.setValue(4, (short)2);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((long)1L, (long)array.getValue(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((long)2L, (long)array.getValue(4));
    }

    @Test
    public void testAddValueIndex() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        int e0 = 7;
        boolean e4 = true;
        int e7 = 2;
        array.addValue(0, (short)7);
        array.addValue(4, (short)1);
        array.addValue(7, (short)2);
        Assert.assertEquals((long)(raw.length + 3), (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[0], (long)array.getValue(1));
        Assert.assertEquals((long)raw[1], (long)array.getValue(2));
        Assert.assertEquals((long)raw[2], (long)array.getValue(3));
        Assert.assertEquals((long)1L, (long)array.getValue(4));
        Assert.assertEquals((long)raw[3], (long)array.getValue(5));
        Assert.assertEquals((long)raw[4], (long)array.getValue(6));
        Assert.assertEquals((long)2L, (long)array.getValue(7));
    }

    public void testRemoveIndex() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove(0);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove(2);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove(4);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testIndexOf() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)-1));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)0));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)1));
        Assert.assertEquals((long)-1L, (long)array.indexOf((short)Short.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.indexOf((short)Short.MIN_VALUE));
    }

    @Test
    public void testLastIndexOf() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)-1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)0));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((short)Short.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((short)Short.MIN_VALUE));
    }

    @Test
    public void testContains() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains(raw[i]));
        }
        Assert.assertFalse((boolean)array.contains((Object)-1));
        Assert.assertFalse((boolean)array.contains((Object)0));
        Assert.assertFalse((boolean)array.contains((Object)1));
        Assert.assertFalse((boolean)array.contains((short)Short.MAX_VALUE));
        Assert.assertFalse((boolean)array.contains((short)Short.MIN_VALUE));
    }

    @Test
    public void testSetArray() {
        ShortArray array = new ShortArray();
        short[] raw = new short[]{1, 2, 3, 5, 8, 13, 21};
        array.setArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
    }

    @Test
    public void testInsert() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        this.testInsert((PrimitiveArray<?, ?>)new ShortArray(raw));
    }

    @Test
    public void testDelete() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        this.testDelete((PrimitiveArray<?, ?>)new ShortArray(raw));
    }

    @Test
    public void testGet() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.get(i).shortValue());
        }
    }

    @Test
    public void testSet() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        Short e0 = 7;
        Short e2 = 1;
        Short e4 = 2;
        array.set(0, e0);
        array.set(2, e2);
        array.set(4, e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((Object)e0, (Object)array.get(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((Object)e2, (Object)array.get(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((Object)e4, (Object)array.get(4));
    }

    @Test
    public void testAdd() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        Short e6 = 1;
        Short e7 = 2;
        array.add((Object)e6);
        array.add((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((Object)e6, (Object)array.get(5));
        Assert.assertEquals((Object)e7, (Object)array.get(6));
    }

    @Test
    public void testIndexOfBoxed() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)new Short(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Short(-1)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Short(0)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Short(1)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Short(Short.MAX_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Short(Short.MIN_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.indexOf(null));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)"Not a short"));
    }

    @Test
    public void testLastIndexOfBoxed() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)new Short(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Short(-1)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Short(0)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Short(1)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Short(Short.MAX_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Short(Short.MIN_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)"Not a short"));
    }

    @Test
    public void testContainsBoxed() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)new Short(raw[i])));
        }
        Assert.assertFalse((boolean)array.contains((Object)new Short(-1)));
        Assert.assertFalse((boolean)array.contains((Object)new Short(0)));
        Assert.assertFalse((boolean)array.contains((Object)new Short(1)));
        Assert.assertFalse((boolean)array.contains((Object)new Short(Short.MAX_VALUE)));
        Assert.assertFalse((boolean)array.contains((Object)new Short(Short.MIN_VALUE)));
        Assert.assertFalse((boolean)array.contains(null));
        Assert.assertFalse((boolean)array.contains((Object)"Not a short"));
    }

    @Test
    public void testRemove() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove((Object)new Short(raw[0]));
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove((Object)new Short(raw[2]));
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove((Object)new Short(raw[4]));
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testContainsAll() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        ArrayList<Short> list = new ArrayList<Short>();
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add((short)13);
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add((short)1);
        Assert.assertFalse((boolean)array.containsAll(list));
        ShortArray yes = new ShortArray(new short[]{3, 8, 21});
        Assert.assertTrue((boolean)array.containsAll((Collection)yes));
        ShortArray no = new ShortArray(new short[]{5, 13, 1});
        Assert.assertFalse((boolean)array.containsAll((Collection)no));
    }

    @Test
    public void testAddAll() {
        int i;
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        short[] add = new short[]{1, 7};
        ShortArray toAdd = new ShortArray((short[])add.clone());
        int index = 3;
        array.addAll(3, (Collection)toAdd);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)raw[i], (long)array.getValue(i));
        }
        for (i = 3; i < 3 + add.length; ++i) {
            Assert.assertEquals((long)add[i - 3], (long)array.getValue(i));
        }
        for (i = 3 + add.length; i < raw.length + add.length; ++i) {
            Assert.assertEquals((long)raw[i - add.length], (long)array.getValue(i));
        }
    }

    @Test
    public void testRemoveAll() {
        short[] raw = new short[]{3, 5, 8, 13, 21};
        ShortArray array = new ShortArray((short[])raw.clone());
        ShortArray toRemove = new ShortArray(new short[]{3, 8, 21});
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeAll((Collection)toRemove);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }
}

