/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.prefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.AbstractPrefService;
import org.scijava.prefs.PrefService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultPrefService
extends AbstractPrefService {
    @Override
    public String get(String name) {
        return this.get((Class)null, name);
    }

    @Override
    public String get(String name, String defaultValue) {
        return this.get(null, name, defaultValue);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return this.getBoolean(null, name, defaultValue);
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        return this.getDouble(null, name, defaultValue);
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        return this.getFloat(null, name, defaultValue);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        return this.getInt(null, name, defaultValue);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        return this.getLong(null, name, defaultValue);
    }

    @Override
    public void put(String name, String value) {
        this.put(null, name, value);
    }

    @Override
    public void put(String name, boolean value) {
        this.put(null, name, value);
    }

    @Override
    public void put(String name, double value) {
        this.put(null, name, value);
    }

    @Override
    public void put(String name, float value) {
        this.put((Class<?>)null, name, value);
    }

    @Override
    public void put(String name, int value) {
        this.put((Class<?>)null, name, value);
    }

    @Override
    public void put(String name, long value) {
        this.put((Class<?>)null, name, value);
    }

    @Override
    public String get(Class<?> c, String name) {
        return this.get(c, name, null);
    }

    @Override
    public String get(Class<?> c, String name, String defaultValue) {
        return this.prefs(c).get(this.key(c, name), defaultValue);
    }

    @Override
    public boolean getBoolean(Class<?> c, String name, boolean defaultValue) {
        return this.prefs(c).getBoolean(this.key(c, name), defaultValue);
    }

    @Override
    public double getDouble(Class<?> c, String name, double defaultValue) {
        return this.prefs(c).getDouble(this.key(c, name), defaultValue);
    }

    @Override
    public float getFloat(Class<?> c, String name, float defaultValue) {
        return this.prefs(c).getFloat(this.key(c, name), defaultValue);
    }

    @Override
    public int getInt(Class<?> c, String name, int defaultValue) {
        return this.prefs(c).getInt(this.key(c, name), defaultValue);
    }

    @Override
    public long getLong(Class<?> c, String name, long defaultValue) {
        return this.prefs(c).getLong(this.key(c, name), defaultValue);
    }

    @Override
    public void put(Class<?> c, String name, String value) {
        this.prefs(c).put(this.key(c, name), value);
    }

    @Override
    public void put(Class<?> c, String name, boolean value) {
        this.prefs(c).putBoolean(this.key(c, name), value);
    }

    @Override
    public void put(Class<?> c, String name, double value) {
        this.prefs(c).putDouble(this.key(c, name), value);
    }

    @Override
    public void put(Class<?> c, String name, float value) {
        this.prefs(c).putFloat(this.key(c, name), value);
    }

    @Override
    public void put(Class<?> c, String name, int value) {
        this.prefs(c).putInt(this.key(c, name), value);
    }

    @Override
    public void put(Class<?> c, String name, long value) {
        this.prefs(c).putLong(this.key(c, name), value);
    }

    @Override
    public void clear(Class<?> c) {
        try {
            this.prefs(c).clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public void clearAll() {
        try {
            for (String name : this.allPrefs()) {
                this.prefs(name).removeNode();
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public void clear(String key) {
        this.clear((Class)null, key);
    }

    @Override
    public void clear(Class<?> prefClass, String key) {
        Preferences preferences = this.prefs(prefClass);
        this.clear(preferences, key);
    }

    @Override
    public void clear(String absolutePath, String key) {
        Preferences preferences = this.prefs(absolutePath);
        this.clear(preferences, key);
    }

    @Override
    public void remove(Class<?> prefClass, String key) {
        Preferences preferences = this.prefs(prefClass);
        this.remove(preferences, key);
    }

    @Override
    public void remove(String absolutePath, String key) {
        Preferences preferences = this.prefs(absolutePath);
        this.remove(preferences, key);
    }

    @Override
    public void putMap(Map<String, String> map, String key) {
        this.putMap((Class)null, map, key);
    }

    @Override
    public void putMap(Class<?> prefClass, Map<String, String> map, String key) {
        Preferences preferences = this.prefs(prefClass);
        this.putMap(preferences.node(key), map);
    }

    @Override
    public void putMap(String absolutePath, Map<String, String> map, String key) {
        Preferences preferences = this.prefs(absolutePath);
        this.putMap(preferences.node(key), map);
    }

    @Override
    public void putMap(Class<?> prefClass, Map<String, String> map) {
        Preferences preferences = this.prefs(prefClass);
        this.putMap(preferences, map);
    }

    @Override
    public void putMap(String absolutePath, Map<String, String> map) {
        Preferences preferences = this.prefs(absolutePath);
        this.putMap(preferences, map);
    }

    @Override
    public Map<String, String> getMap(String key) {
        return this.getMap((Class)null, key);
    }

    @Override
    public Map<String, String> getMap(Class<?> prefClass, String key) {
        Preferences preferences = this.prefs(prefClass);
        return this.getMap(preferences.node(key));
    }

    @Override
    public Map<String, String> getMap(String absolutePath, String key) {
        Preferences preferences = this.prefs(absolutePath);
        return this.getMap(preferences.node(key));
    }

    @Override
    public Map<String, String> getMap(Class<?> prefClass) {
        Preferences preferences = this.prefs(prefClass);
        return this.getMap(preferences);
    }

    @Override
    public void putList(List<String> list, String key) {
        this.putList((Class)null, list, key);
    }

    @Override
    public void putList(Class<?> prefClass, List<String> list, String key) {
        Preferences preferences = this.prefs(prefClass);
        this.putList(preferences.node(key), list);
    }

    @Override
    public void putList(String absolutePath, List<String> list, String key) {
        Preferences preferences = this.prefs(absolutePath);
        this.putList(preferences.node(key), list);
    }

    @Override
    public void putList(Class<?> prefClass, List<String> list) {
        Preferences preferences = this.prefs(prefClass);
        this.putList(preferences, list);
    }

    @Override
    public void putList(String absolutePath, List<String> list) {
        Preferences preferences = this.prefs(absolutePath);
        this.putList(preferences, list);
    }

    @Override
    public List<String> getList(String key) {
        return this.getList((Class)null, key);
    }

    @Override
    public List<String> getList(Class<?> prefClass, String key) {
        Preferences preferences = this.prefs(prefClass);
        return this.getList(preferences.node(key));
    }

    @Override
    public List<String> getList(String absolutePath, String key) {
        Preferences preferences = this.prefs(absolutePath);
        return this.getList(preferences.node(key));
    }

    @Override
    public List<String> getList(Class<?> prefClass) {
        Preferences preferences = this.prefs(prefClass);
        return this.getList(preferences);
    }

    private void clear(Preferences preferences, String key) {
        try {
            if (preferences.nodeExists(key)) {
                preferences.node(key).clear();
            }
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    private void remove(Preferences preferences, String key) {
        try {
            if (preferences.nodeExists(key)) {
                preferences.node(key).removeNode();
            }
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    private void putMap(Preferences preferences, Map<String, String> map) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences not set.");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            preferences.put(entry.getKey().toString(), value == null ? null : value.toString());
        }
    }

    private Map<String, String> getMap(Preferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences not set.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String[] keys = preferences.keys();
            for (int index = 0; index < keys.length; ++index) {
                map.put(keys[index], preferences.get(keys[index], null));
            }
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
        return map;
    }

    private void putList(Preferences preferences, List<String> list) {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences not set.");
        }
        for (int index = 0; list != null && index < list.size(); ++index) {
            String value = list.get(index);
            preferences.put("" + index, value == null ? null : value.toString());
        }
    }

    private List<String> getList(Preferences preferences) {
        String value;
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences not set.");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int index = 0; index < 1000 && (value = preferences.get("" + index, null)) != null; ++index) {
            list.add(value);
        }
        return list;
    }

    private Preferences prefs(Class<?> c) {
        return Preferences.userNodeForPackage(c == null ? PrefService.class : c);
    }

    private String[] allPrefs() throws BackingStoreException {
        return Preferences.userRoot().childrenNames();
    }

    private Preferences prefs(String absolutePath) {
        return Preferences.userRoot().node(absolutePath);
    }

    private String key(Class<?> c, String name) {
        return c == null ? name : c.getSimpleName() + "." + name;
    }
}

