/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.plugin.Parameter;
import org.scijava.service.AbstractService;

public class ContextInjectionTest {
    @Test
    public void testAbstractContextualSetContext() {
        Context context = new Context(new Class[]{FooService.class});
        NeedsFooContextual needsFoo = new NeedsFooContextual();
        Assert.assertNull((Object)((Object)needsFoo.fooService));
        needsFoo.setContext(context);
        Assert.assertSame((Object)context, (Object)needsFoo.getContext());
        Assert.assertSame((Object)context.getService(FooService.class), (Object)((Object)needsFoo.fooService));
    }

    @Test
    public void testAbstractContextualContextInject() {
        Context context = new Context(new Class[]{FooService.class});
        NeedsFooContextual needsFoo = new NeedsFooContextual();
        Assert.assertNull((Object)((Object)needsFoo.fooService));
        context.inject((Object)needsFoo);
        Assert.assertSame((Object)context, (Object)needsFoo.getContext());
        Assert.assertSame((Object)context.getService(FooService.class), (Object)((Object)needsFoo.fooService));
    }

    @Test
    public void testNonContextualServiceParameters() {
        Context context = new Context(new Class[]{FooService.class});
        NeedsFooPlain needsFoo = new NeedsFooPlain();
        Assert.assertNull((Object)((Object)needsFoo.fooService));
        context.inject((Object)needsFoo);
        Assert.assertSame((Object)context.getService(FooService.class), (Object)((Object)needsFoo.fooService));
    }

    @Test
    public void testNonContextualContextParameters() {
        Context context = new Context(true);
        NeedsContext needsContext = new NeedsContext();
        Assert.assertNull((Object)needsContext.context);
        context.inject((Object)needsContext);
        Assert.assertSame((Object)context, (Object)needsContext.context);
        try {
            context.inject((Object)needsContext);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException exc) {
            String expectedMessage = "Context already injected: " + needsContext.getClass().getName() + "#context";
            Assert.assertEquals((Object)expectedMessage, (Object)exc.getMessage());
        }
    }

    @Test
    public void testContextSubclassInjection() {
        Context c = new Context(true);
        FooContext foo = new FooContext();
        BarContext bar = new BarContext();
        ContextSubclassParameters cspPlain = new ContextSubclassParameters();
        c.inject((Object)cspPlain);
        Assert.assertSame((Object)c, (Object)cspPlain.c);
        Assert.assertNull((Object)((Object)cspPlain.foo));
        Assert.assertNull((Object)((Object)cspPlain.bar));
        ContextSubclassParameters cspFoo = new ContextSubclassParameters();
        foo.inject(cspFoo);
        Assert.assertNull((Object)cspFoo.o);
        Assert.assertSame((Object)((Object)foo), (Object)cspFoo.c);
        Assert.assertSame((Object)((Object)foo), (Object)((Object)cspFoo.foo));
        Assert.assertNull((Object)((Object)cspFoo.bar));
        ContextSubclassParameters cspBar = new ContextSubclassParameters();
        bar.inject(cspBar);
        Assert.assertNull((Object)cspBar.o);
        Assert.assertSame((Object)((Object)bar), (Object)cspBar.c);
        Assert.assertNull((Object)((Object)cspBar.foo));
        Assert.assertSame((Object)((Object)bar), (Object)((Object)cspBar.bar));
    }

    @Test
    public void testAbstractContextualEventSubscription() {
        Context context = new Context(new Class[]{EventService.class});
        EventService eventService = (EventService)context.getService(EventService.class);
        HasEventsContextual hasEvents = new HasEventsContextual();
        Assert.assertFalse((boolean)hasEvents.eventReceived);
        eventService.publish(new SciJavaEvent(){});
        Assert.assertFalse((boolean)hasEvents.eventReceived);
        hasEvents.setContext(context);
        eventService.publish(new SciJavaEvent(){});
        Assert.assertTrue((boolean)hasEvents.eventReceived);
    }

    @Test
    public void testNonContextualEventSubscription() {
        Context context = new Context(new Class[]{EventService.class});
        EventService eventService = (EventService)context.getService(EventService.class);
        HasEventsPlain hasEvents = new HasEventsPlain();
        Assert.assertFalse((boolean)hasEvents.eventReceived);
        eventService.publish(new SciJavaEvent(){});
        Assert.assertFalse((boolean)hasEvents.eventReceived);
        context.inject((Object)hasEvents);
        eventService.publish(new SciJavaEvent(){});
        Assert.assertTrue((boolean)hasEvents.eventReceived);
    }

    public static class HasEventsPlain {
        private boolean eventReceived;

        @EventHandler
        private void onEvent(SciJavaEvent e) {
            this.eventReceived = true;
        }
    }

    public static class HasEventsContextual
    extends AbstractContextual {
        private boolean eventReceived;

        @EventHandler
        private void onEvent(SciJavaEvent e) {
            this.eventReceived = true;
        }
    }

    public static class BarContext
    extends Context {
        public BarContext() {
            super(true);
        }
    }

    public static class FooContext
    extends Context {
        public FooContext() {
            super(true);
        }
    }

    public static class ContextSubclassParameters {
        @Parameter
        private Object o;
        @Parameter
        private Context c;
        @Parameter
        private FooContext foo;
        @Parameter
        private BarContext bar;
    }

    public static class NeedsContext {
        @Parameter
        private Context context;
    }

    public static class NeedsFooPlain {
        @Parameter
        private FooService fooService;
    }

    public static class NeedsFooContextual
    extends AbstractContextual {
        @Parameter
        private FooService fooService;
    }

    public static class FooService
    extends AbstractService {
    }
}

