/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ConversionUtils;

@Plugin(type=Converter.class, priority=Infinity)
public class NullConverter
extends AbstractConverter<Object, Object> {
    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        return src == null;
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        if (dest == null) {
            return null;
        }
        if (src == null) {
            return ConversionUtils.getNullValue(dest);
        }
        throw new IllegalArgumentException("Attempting non-null conversion: " + src + " > " + dest + " using NullConverter.");
    }

    @Override
    public Class<Object> getOutputType() {
        return Object.class;
    }

    @Override
    public Class<Object> getInputType() {
        return Object.class;
    }

    @Override
    @Deprecated
    public boolean canConvert(Class<?> src, Class<?> dest) {
        return false;
    }
}

