/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.test.TestUtils;

public class TestUtilsTest {
    @Test
    public void testCreateTemporaryDirectory() throws IOException {
        File tmp1 = TestUtils.createTemporaryDirectory((String)"test-utils-test-");
        Assert.assertTrue((String)("Not in target/: " + tmp1.getAbsolutePath()), (boolean)tmp1.getAbsolutePath().replace('\\', '/').contains("/target/"));
        File tmp2 = TestUtils.createTemporaryDirectory((String)"test-utils-test-");
        Assert.assertTrue((!tmp1.getAbsolutePath().equals(tmp2.getAbsolutePath()) ? 1 : 0) != 0);
        File tmp3 = TestUtils.createTemporaryDirectory((String)"test-utils-test-", this.getClass());
        Assert.assertTrue((String)("Not in target/: " + tmp3.getAbsolutePath()), (boolean)tmp3.getAbsolutePath().replace('\\', '/').contains("/target/"));
        File tmp4 = TestUtils.createTemporaryDirectory((String)"test-utils-test-", this.getClass());
        Assert.assertTrue((!tmp3.getAbsolutePath().equals(tmp4.getAbsolutePath()) ? 1 : 0) != 0);
    }

    @Test
    public void sameDirectoryTwice() throws IOException {
        FileOutputStream[] out = new FileOutputStream[2];
        for (int i = 0; i < 2; ++i) {
            File tmp = TestUtils.createTemporaryDirectory((String)"same-");
            Assert.assertTrue((tmp != null ? 1 : 0) != 0);
            Object[] list = tmp.list();
            Assert.assertTrue((String)("Not null: " + Arrays.toString(list)), (list == null || list.length == 0 ? 1 : 0) != 0);
            out[i] = new FileOutputStream(new File(tmp, "hello" + i + ".txt"));
        }
        for (FileOutputStream stream : out) {
            if (stream == null) continue;
            stream.close();
        }
    }

    @Test
    public void testCreatePath() throws IOException {
        File base = TestUtils.createTemporaryDirectory((String)"create-path-");
        String path = "/my/what/a/nested/directory/structure/you/have/gramma";
        File file = TestUtils.createPath((File)base, (String)"/my/what/a/nested/directory/structure/you/have/gramma");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertEquals((Object)"gramma", (Object)file.getName());
        file = file.getParentFile();
        Assert.assertEquals((Object)"have", (Object)file.getName());
        file = file.getParentFile();
        Assert.assertEquals((Object)"you", (Object)file.getName());
        file = file.getParentFile();
        Assert.assertEquals((Object)"structure", (Object)file.getName());
        file = file.getParentFile();
        Assert.assertEquals((Object)"directory", (Object)file.getName());
        file = file.getParentFile();
        Assert.assertEquals((Object)"nested", (Object)file.getName());
        file = file.getParentFile();
        Assert.assertEquals((Object)"a", (Object)file.getName());
        file = file.getParentFile();
        Assert.assertEquals((Object)"what", (Object)file.getName());
        file = file.getParentFile();
        Assert.assertEquals((Object)"my", (Object)file.getName());
        file = file.getParentFile();
        Assert.assertEquals((Object)base, (Object)file);
    }
}

