/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.scijava.AbstractContextual;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptService;

public class ScriptFinder
extends AbstractContextual {
    private static final String SCRIPT_ICON = "/icons/script_code.png";
    private final ScriptService scriptService;
    @Parameter
    private LogService log;

    public ScriptFinder(ScriptService scriptService) {
        this.scriptService = scriptService;
        this.setContext(scriptService.getContext());
    }

    public void findScripts(List<ScriptInfo> scripts) {
        List<File> directories = this.scriptService.getScriptDirectories();
        int scriptCount = 0;
        HashSet<File> scriptFiles = new HashSet<File>();
        for (File directory : directories) {
            if (!directory.exists()) {
                this.log.debug("Ignoring non-existent scripts directory: " + directory.getAbsolutePath());
                continue;
            }
            MenuPath prefix = this.scriptService.getMenuPrefix(directory);
            MenuPath menuPath = prefix == null ? new MenuPath() : prefix;
            scriptCount += this.discoverScripts(scripts, scriptFiles, directory, menuPath);
        }
        this.log.debug("Found " + scriptCount + " scripts");
    }

    private int discoverScripts(List<ScriptInfo> scripts, Set<File> scriptFiles, File directory, MenuPath menuPath) {
        Object[] fileList = directory.listFiles();
        if (fileList == null) {
            return 0;
        }
        Arrays.sort(fileList);
        int scriptCount = 0;
        boolean isTopLevel = menuPath.size() == 0;
        for (Object file : fileList) {
            if (scriptFiles.contains(file)) continue;
            String name = ((File)file).getName().replace('_', ' ');
            if (((File)file).isDirectory()) {
                this.discoverScripts(scripts, scriptFiles, (File)file, this.subMenuPath(menuPath, name));
                continue;
            }
            if (isTopLevel || !this.scriptService.canHandleFile((File)file)) continue;
            int dot = name.lastIndexOf(46);
            String noExt = dot <= 0 ? name : name.substring(0, dot);
            scripts.add(this.createEntry((File)file, this.subMenuPath(menuPath, noExt)));
            scriptFiles.add((File)file);
            ++scriptCount;
        }
        return scriptCount;
    }

    private MenuPath subMenuPath(MenuPath menuPath, String subMenuName) {
        MenuPath result = new MenuPath(menuPath);
        result.add(new MenuEntry(subMenuName));
        return result;
    }

    private ScriptInfo createEntry(File scriptFile, MenuPath menuPath) {
        ScriptInfo info = new ScriptInfo(this.getContext(), scriptFile);
        info.setMenuPath(menuPath);
        menuPath.getLeaf().setIconPath(SCRIPT_ICON);
        return info;
    }
}

