/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import org.scijava.Context;
import org.scijava.console.ConsoleArgument;
import org.scijava.console.ConsoleService;
import org.scijava.console.MultiPrintStream;
import org.scijava.console.OutputEvent;
import org.scijava.console.OutputListener;
import org.scijava.log.LogService;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;

@Plugin(type=Service.class)
public class DefaultConsoleService
extends AbstractHandlerService<LinkedList<String>, ConsoleArgument>
implements ConsoleService {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private LogService log;
    private MultiPrintStream sysout;
    private MultiPrintStream syserr;
    private OutputStreamReporter out;
    private OutputStreamReporter err;
    private ArrayList<OutputListener> listeners;
    private OutputListener[] cachedListeners;

    @Override
    public void processArgs(String ... args) {
        this.log.debug("Received command line arguments:");
        LinkedList<String> argList = new LinkedList<String>();
        for (String arg : args) {
            this.log.debug("\t" + arg);
            argList.add(arg);
        }
        while (!argList.isEmpty()) {
            ConsoleArgument handler = (ConsoleArgument)this.getHandler(argList);
            if (handler == null) {
                String arg = (String)argList.removeFirst();
                this.log.warn("Ignoring invalid argument: " + arg);
                continue;
            }
            handler.handle(argList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutputListener(OutputListener l) {
        if (this.listeners == null) {
            this.initListeners();
        }
        ArrayList<OutputListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
            this.cacheListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOutputListener(OutputListener l) {
        if (this.listeners == null) {
            this.initListeners();
        }
        ArrayList<OutputListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
            this.cacheListeners();
        }
    }

    @Override
    public void notifyListeners(OutputEvent event) {
        OutputListener[] toNotify;
        if (this.listeners == null) {
            this.initListeners();
        }
        for (OutputListener l : toNotify = this.cachedListeners) {
            l.outputOccurred(event);
        }
    }

    @Override
    public Class<ConsoleArgument> getPluginType() {
        return ConsoleArgument.class;
    }

    @Override
    public Class<LinkedList<String>> getType() {
        return LinkedList.class;
    }

    @Override
    public void dispose() {
        if (this.out != null) {
            this.sysout.getParent().removeOutputStream(this.out);
        }
        if (this.err != null) {
            this.syserr.getParent().removeOutputStream(this.err);
        }
    }

    private synchronized void initListeners() {
        if (this.listeners != null) {
            return;
        }
        this.sysout = this.multiPrintStream(System.out);
        if (System.out != this.sysout) {
            System.setOut(this.sysout);
        }
        this.out = new OutputStreamReporter(OutputEvent.Source.STDOUT);
        this.sysout.getParent().addOutputStream(this.out);
        this.syserr = this.multiPrintStream(System.err);
        if (System.err != this.syserr) {
            System.setErr(this.syserr);
        }
        this.err = new OutputStreamReporter(OutputEvent.Source.STDERR);
        this.syserr.getParent().addOutputStream(this.err);
        this.listeners = new ArrayList();
        this.cachedListeners = this.listeners.toArray(new OutputListener[0]);
    }

    private void cacheListeners() {
        this.cachedListeners = this.listeners.toArray(new OutputListener[this.listeners.size()]);
    }

    private MultiPrintStream multiPrintStream(PrintStream ps) {
        if (ps instanceof MultiPrintStream) {
            return (MultiPrintStream)ps;
        }
        return new MultiPrintStream(ps);
    }

    private class OutputStreamReporter
    extends OutputStream {
        private final OutputEvent.Source source;

        public OutputStreamReporter(OutputEvent.Source source) {
            this.source = source;
        }

        @Override
        public void write(int b) {
            ThreadService.ThreadContext relevance = this.getRelevance();
            if (relevance == ThreadService.ThreadContext.OTHER) {
                return;
            }
            this.publish(relevance, "" + b);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            ThreadService.ThreadContext relevance = this.getRelevance();
            if (relevance == ThreadService.ThreadContext.OTHER) {
                return;
            }
            this.publish(relevance, new String(buf, off, len));
        }

        private ThreadService.ThreadContext getRelevance() {
            return DefaultConsoleService.this.threadService.getThreadContext(Thread.currentThread());
        }

        private void publish(ThreadService.ThreadContext relevance, String output) {
            Context context = DefaultConsoleService.this.getContext();
            boolean contextual = relevance == ThreadService.ThreadContext.SAME;
            OutputEvent event = new OutputEvent(context, this.source, output, contextual);
            DefaultConsoleService.this.notifyListeners(event);
        }
    }
}

