/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.scijava.log.LogService;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;

public final class ConsoleUtils {
    public static Map<String, Object> parseParameterString(String parameterString) {
        return ConsoleUtils.parseParameterString(parameterString, (ModuleInfo)null);
    }

    public static Map<String, Object> parseParameterString(String parameterString, ModuleInfo info) {
        return ConsoleUtils.parseParameterString(parameterString, info, null);
    }

    public static Map<String, Object> parseParameterString(String parameterString, LogService logService) {
        return ConsoleUtils.parseParameterString(parameterString, null, logService);
    }

    public static Map<String, Object> parseParameterString(String parameterString, ModuleInfo info, LogService logService) {
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        if (!parameterString.isEmpty()) {
            String[] pairs;
            Iterator<ModuleItem<?>> inputs = null;
            if (info != null) {
                inputs = info.inputs().iterator();
            }
            for (String pair : pairs = parameterString.split(",")) {
                String[] split = pair.split("=");
                if (split.length == 2) {
                    inputMap.put(split[0], split[1]);
                    continue;
                }
                if (inputs != null && inputs.hasNext() && split.length == 1) {
                    inputMap.put(inputs.next().getName(), split[0]);
                    continue;
                }
                if (logService == null) continue;
                logService.error("Parameters must be formatted as a comma-separated list of key=value pairs");
            }
        }
        return inputMap;
    }
}

