/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.input;

import java.util.HashSet;
import org.scijava.display.Display;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.display.event.input.KyPressedEvent;
import org.scijava.display.event.input.KyReleasedEvent;
import org.scijava.display.event.input.MsExitedEvent;
import org.scijava.display.event.input.MsMovedEvent;
import org.scijava.display.event.input.MsPressedEvent;
import org.scijava.display.event.input.MsReleasedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.input.InputModifiers;
import org.scijava.input.InputService;
import org.scijava.input.KeyCode;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultInputService
extends AbstractService
implements InputService {
    @Parameter
    private EventService eventService;
    private InputModifiers modifiers;
    private boolean altDown = false;
    private boolean altGrDown = false;
    private boolean ctrlDown = false;
    private boolean metaDown = false;
    private boolean shiftDown = false;
    private HashSet<KeyCode> pressedKeys = new HashSet();
    private HashSet<Integer> buttonsDown = new HashSet();
    private Display<?> display;
    private int lastX = -1;
    private int lastY = -1;

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public InputModifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean isAltDown() {
        return this.altDown;
    }

    @Override
    public boolean isAltGrDown() {
        return this.altGrDown;
    }

    @Override
    public boolean isCtrlDown() {
        return this.ctrlDown;
    }

    @Override
    public boolean isMetaDown() {
        return this.metaDown;
    }

    @Override
    public boolean isShiftDown() {
        return this.shiftDown;
    }

    @Override
    public boolean isKeyDown(KeyCode code) {
        return this.pressedKeys.contains((Object)code);
    }

    @Override
    public Display<?> getDisplay() {
        return this.display;
    }

    @Override
    public int getX() {
        return this.lastX;
    }

    @Override
    public int getY() {
        return this.lastY;
    }

    @Override
    public boolean isButtonDown(int button) {
        return this.buttonsDown.contains(button);
    }

    @EventHandler
    public void onEvent(KyPressedEvent evt) {
        this.modifiers = evt.getModifiers();
        this.altDown = this.modifiers.isAltDown();
        this.altGrDown = this.modifiers.isAltGrDown();
        this.ctrlDown = this.modifiers.isCtrlDown();
        this.metaDown = this.modifiers.isMetaDown();
        this.shiftDown = this.modifiers.isShiftDown();
        this.pressedKeys.add(evt.getCode());
    }

    @EventHandler
    public void onEvent(KyReleasedEvent evt) {
        this.modifiers = evt.getModifiers();
        this.altDown = this.modifiers.isAltDown();
        this.altGrDown = this.modifiers.isAltGrDown();
        this.ctrlDown = this.modifiers.isCtrlDown();
        this.metaDown = this.modifiers.isMetaDown();
        this.shiftDown = this.modifiers.isShiftDown();
        this.pressedKeys.remove((Object)evt.getCode());
    }

    @EventHandler
    protected void onEvent(MsMovedEvent evt) {
        this.updateCoords(evt.getDisplay(), evt.getX(), evt.getY());
    }

    @EventHandler
    protected void onEvent(MsExitedEvent evt) {
        this.clearCoords();
    }

    @EventHandler
    protected void onEvent(MsPressedEvent evt) {
        this.modifiers = evt.getModifiers();
        this.buttonsDown.add(evt.getButton());
    }

    @EventHandler
    protected void onEvent(MsReleasedEvent evt) {
        this.modifiers = evt.getModifiers();
        this.buttonsDown.remove(evt.getButton());
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent evt) {
        if (this.display != evt.getObject()) {
            return;
        }
        this.clearCoords();
    }

    private void updateCoords(Display<?> d, int x, int y) {
        this.display = d;
        this.lastX = x;
        this.lastY = y;
    }

    private void clearCoords() {
        this.updateCoords(null, -1, -1);
    }
}

