/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.dnd;

import org.scijava.app.StatusService;
import org.scijava.display.Display;
import org.scijava.event.EventHandler;
import org.scijava.plugin.AbstractHandlerService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;
import org.scijava.ui.dnd.DragAndDropData;
import org.scijava.ui.dnd.DragAndDropHandler;
import org.scijava.ui.dnd.DragAndDropService;
import org.scijava.ui.dnd.event.DragEnterEvent;
import org.scijava.ui.dnd.event.DragExitEvent;
import org.scijava.ui.dnd.event.DragOverEvent;
import org.scijava.ui.dnd.event.DropEvent;

@Plugin(type=Service.class)
public class DefaultDragAndDropService
extends AbstractHandlerService<Object, DragAndDropHandler<Object>>
implements DragAndDropService {
    private static final String SUPPORTED = "Drag and Drop";
    private static final String UNSUPPORTED = "Unsupported Object";
    @Parameter
    private StatusService statusService;

    @Override
    public boolean supports(DragAndDropData data, Display<?> display) {
        return this.getHandler(data, display) != null;
    }

    @Override
    public boolean supports(Object object, Display<?> display) {
        return this.getHandler(object, display) != null;
    }

    @Override
    public boolean drop(DragAndDropData data, Display<?> display) {
        DragAndDropHandler<?> handler = this.getHandler(data, display);
        if (handler == null) {
            return false;
        }
        return handler.dropData(data, display);
    }

    @Override
    public boolean drop(Object data, Display<?> display) {
        DragAndDropHandler<?> handler = this.getHandler(data, display);
        if (handler == null) {
            return false;
        }
        return handler.dropObject(data, display);
    }

    @Override
    public DragAndDropHandler<?> getHandler(DragAndDropData data, Display<?> display) {
        for (DragAndDropHandler handler : this.getInstances()) {
            if (!handler.supportsData(data, display)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public DragAndDropHandler<?> getHandler(Object object, Display<?> display) {
        for (DragAndDropHandler handler : this.getInstances()) {
            if (!handler.supportsObject(object, display)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public Class<DragAndDropHandler<Object>> getPluginType() {
        return DragAndDropHandler.class;
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @EventHandler
    protected void onEvent(DragEnterEvent e) {
        boolean compatible = this.supports(e.getData(), e.getDisplay());
        String message = compatible ? SUPPORTED : UNSUPPORTED;
        this.statusService.showStatus("< <" + message + "> >");
        if (compatible) {
            e.setAccepted(true);
        }
    }

    @EventHandler
    protected void onEvent(DragExitEvent e) {
        this.statusService.clearStatus();
    }

    @EventHandler
    protected void onEvent(DragOverEvent e) {
    }

    @EventHandler
    protected void onEvent(DropEvent e) {
        if (!this.supports(e.getData(), e.getDisplay())) {
            return;
        }
        boolean success = this.drop(e.getData(), e.getDisplay());
        e.setSuccessful(success);
    }
}

