/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command.run;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.command.run.CommandCodeRunner;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public class CommandCodeRunnerTest {
    private Context context;
    private CommandCodeRunner runner;

    @Before
    public void setUp() {
        this.context = new Context(new Class[]{CommandService.class});
        this.runner = new CommandCodeRunner();
        this.context.inject((Object)this.runner);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testRunList() throws InvocationTargetException {
        StringBuilder buffer = new StringBuilder();
        this.runner.run(OpenSesame.class, new Object[]{"buffer", buffer});
        Assert.assertEquals((Object)"Alakazam", (Object)buffer.toString());
        this.runner.run(OpenSesame.class, new Object[]{"buffer", buffer, "magicWord", "Shazam"});
        Assert.assertEquals((Object)"AlakazamShazam", (Object)buffer.toString());
        this.runner.run((Object)"Open Sesame", new Object[]{"buffer", buffer, "magicWord", "Marzipan"});
        Assert.assertEquals((Object)"AlakazamShazamMarzipan", (Object)buffer.toString());
    }

    @Test
    public void testRunMap() throws InvocationTargetException {
        StringBuilder buffer = new StringBuilder();
        HashMap<String, CharSequence> inputMap = new HashMap<String, CharSequence>();
        inputMap.put("buffer", buffer);
        this.runner.run(OpenSesame.class, inputMap);
        Assert.assertEquals((Object)"Alakazam", (Object)buffer.toString());
        inputMap.put("magicWord", "Shazam");
        this.runner.run(OpenSesame.class, inputMap);
        Assert.assertEquals((Object)"AlakazamShazam", (Object)buffer.toString());
        inputMap.put("magicWord", "Marzipan");
        this.runner.run((Object)"Open Sesame", inputMap);
        Assert.assertEquals((Object)"AlakazamShazamMarzipan", (Object)buffer.toString());
    }

    @Test
    public void testSupports() {
        Assert.assertTrue((boolean)this.runner.supports(OpenSesame.class));
        Assert.assertTrue((boolean)this.runner.supports((Object)OpenSesame.class.getName()));
        Assert.assertTrue((boolean)this.runner.supports((Object)"Open Sesame"));
        Assert.assertFalse((boolean)this.runner.supports(CommandCodeRunnerTest.class));
        Assert.assertFalse((boolean)this.runner.supports((Object)"Not an actual command"));
        Assert.assertFalse((boolean)this.runner.supports((Object)0));
    }

    @Plugin(type=Command.class, label="Open Sesame")
    public static class OpenSesame
    implements Command {
        @Parameter(type=ItemIO.BOTH)
        private StringBuilder buffer;
        @Parameter(required=false, persist=false)
        private String magicWord;

        public void run() {
            this.buffer.append(this.magicWord == null ? "Alakazam" : this.magicWord);
        }
    }
}

