/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.display;

import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.display.TextDisplay;

public class DisplayTest {
    @Test
    public void testCreate() {
        Context context = new Context(new Class[]{DisplayService.class});
        DisplayService displayService = (DisplayService)context.getService(DisplayService.class);
        String name = "Create";
        String value = "Some text to display.";
        Display display = displayService.createDisplay("Create", (Object)"Some text to display.");
        Assert.assertNotNull((Object)display);
        Assert.assertEquals((Object)context, (Object)display.getContext());
        Assert.assertEquals((Object)"Create", (Object)display.getName());
        Object result = display.get(0);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Some text to display.", (Object)result);
    }

    @Test
    public void testAddRemove() {
        int i;
        Context context = new Context(new Class[]{DisplayService.class});
        DisplayService displayService = (DisplayService)context.getService(DisplayService.class);
        String name = "AddRemove";
        Object[] values = new Object[]{"quick", "brown", "fox", "jumps"};
        Display display = displayService.createDisplay("AddRemove", values[0]);
        Assert.assertNotNull((Object)display);
        for (i = 1; i < values.length; ++i) {
            display.add(values[i]);
        }
        display.update();
        Assert.assertFalse((boolean)display.isEmpty());
        Assert.assertEquals((long)display.size(), (long)values.length);
        for (i = 0; i < values.length; ++i) {
            Object result = display.get(i);
            Assert.assertEquals((Object)values[i], (Object)result);
        }
        display.remove(0);
        Object result = display.get(0);
        Assert.assertEquals((Object)values[1], (Object)result);
        for (int i2 = 1; i2 < values.length; ++i2) {
            display.remove(0);
        }
        Assert.assertTrue((boolean)display.isEmpty());
    }

    @Test
    public void testText() {
        Context context = new Context(new Class[]{DisplayService.class});
        DisplayService displayService = (DisplayService)context.getService(DisplayService.class);
        String name = "Text";
        String value = "Hello";
        Display d = displayService.createDisplay("Text", (Object)"Hello");
        Assert.assertNotNull((Object)d);
        Assert.assertTrue((boolean)(d instanceof TextDisplay));
        TextDisplay textDisplay = (TextDisplay)d;
        String result = (String)textDisplay.get(0);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Hello", (Object)result);
    }
}

