/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui;

import java.io.File;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;

@Plugin(type=PreprocessorPlugin.class, priority=-9999.5)
public class FilePreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter(required=false)
    private UIService uiService;

    @Override
    public void process(Module module) {
        String style;
        if (this.uiService == null) {
            return;
        }
        ModuleItem<File> fileInput = this.getFileInput(module);
        if (fileInput == null) {
            return;
        }
        File file = fileInput.getValue(module);
        File result = this.uiService.chooseFile(file, style = fileInput.getWidgetStyle());
        if (result == null) {
            this.cancel("");
            return;
        }
        fileInput.setValue(module, result);
        module.setResolved(fileInput.getName(), true);
    }

    private ModuleItem<File> getFileInput(Module module) {
        ModuleItem<?> result = null;
        for (ModuleItem<?> input : module.getInfo().inputs()) {
            ModuleItem<?> fileInput;
            if (module.isResolved(input.getName())) continue;
            Class<?> type = input.getType();
            if (!File.class.isAssignableFrom(type)) {
                return null;
            }
            if (result != null) {
                return null;
            }
            result = fileInput = input;
        }
        return result;
    }
}

