/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import java.io.PrintStream;
import java.util.function.Function;
import org.scijava.log.AbstractLogService;
import org.scijava.log.LogMessage;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Plugin(type=Service.class, priority=-100.0)
public class StderrLogService
extends AbstractLogService {
    private Function<Integer, PrintStream> levelToStream = level -> level <= 2 ? System.err : System.out;

    public void setPrintStreams(Function<Integer, PrintStream> levelToStream) {
        this.levelToStream = levelToStream;
    }

    @Override
    public void notifyListeners(LogMessage message) {
        PrintStream out = this.levelToStream.apply(message.level());
        out.print(message);
    }
}

