/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.scijava.Context;
import org.scijava.Gateway;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.script.DefaultScriptInterpreter;
import org.scijava.script.ScriptInterpreter;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.service.Service;

public class ScriptREPL {
    private static final String NULL = "<null>";
    @Parameter
    private Context context;
    @Parameter
    private ScriptService scriptService;
    @Parameter(required=false)
    private PluginService pluginService;
    private final PrintStream out;
    private List<ScriptLanguage> languages;
    private ScriptInterpreter interpreter;
    private boolean debug;

    public ScriptREPL(Context context) {
        this(context, System.out);
    }

    public ScriptREPL(Context context, OutputStream out) {
        context.inject(this);
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
    }

    public List<ScriptLanguage> getInterpretedLanguages() {
        if (this.languages == null) {
            this.initLanguages();
        }
        return this.languages;
    }

    public ScriptInterpreter getInterpreter() {
        return this.interpreter;
    }

    public void loop() throws IOException {
        this.loop(System.in);
    }

    public void loop(InputStream in) throws IOException {
        block1: {
            String line;
            this.initialize();
            BufferedReader bin = new BufferedReader(new InputStreamReader(in));
            do {
                this.prompt();
                line = bin.readLine();
                if (line == null) break block1;
            } while (this.evaluate(line));
            return;
        }
    }

    public void initialize() {
        this.initialize(true);
    }

    public void initialize(boolean verbose) {
        if (verbose) {
            this.out.println("Welcome to the SciJava REPL!");
            this.out.println();
            this.help();
        }
        List<ScriptLanguage> langs = this.getInterpretedLanguages();
        if (verbose) {
            if (langs.isEmpty()) {
                this.out.println("--------------------------------------------------------------");
                this.out.println("Uh oh! There are no SciJava script languages available!");
                this.out.println("Are any on your classpath? E.g.: org.scijava:scripting-groovy?");
                this.out.println("--------------------------------------------------------------");
                this.out.println();
                return;
            }
            this.out.println("Have fun!");
            this.out.println();
        }
        this.lang(langs.get(0).getLanguageName());
        this.populateBindings(this.interpreter.getBindings());
    }

    public void prompt() {
        this.out.print(this.interpreter == null || this.interpreter.isReady() ? "> " : "\\ ");
    }

    public boolean evaluate(String line) {
        try {
            String tLine = line.trim();
            if (tLine.equals(":help")) {
                this.help();
            } else if (tLine.equals(":vars")) {
                this.vars();
            } else if (tLine.equals(":langs")) {
                this.langs();
            } else if (tLine.equals(":debug")) {
                this.debug();
            } else if (tLine.startsWith(":lang ")) {
                this.lang(line.substring(6).trim());
            } else {
                if (tLine.equals(":quit")) {
                    return false;
                }
                if (this.interpreter == null) {
                    return true;
                }
                Object result = this.interpreter.interpret(line);
                if (result != ScriptInterpreter.MORE_INPUT_PENDING) {
                    this.out.println(ScriptREPL.s(result));
                }
            }
        }
        catch (ScriptException exc) {
            if (this.debug) {
                exc.printStackTrace(this.out);
            } else {
                String msg = exc.getMessage();
                this.out.println(msg == null ? exc.getClass().getName() : msg);
            }
        }
        catch (Throwable exc) {
            exc.printStackTrace(this.out);
        }
        return true;
    }

    public void help() {
        this.out.println("Available built-in commands:");
        this.out.println();
        this.out.println("  :help           | this handy list of commands");
        this.out.println("  :vars           | dump a list of variables");
        this.out.println("  :lang <name>    | switch the active language");
        this.out.println("  :langs          | list available languages");
        this.out.println("  :debug          | toggle full stack traces");
        this.out.println("  :quit           | exit the REPL");
        this.out.println();
        this.out.println("Or type a statement to evaluate it with the active language.");
        this.out.println();
    }

    public void vars() {
        if (this.interpreter == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        Bindings bindings = this.interpreter.getBindings();
        for (String key : bindings.keySet()) {
            Object value = bindings.get(key);
            keys.add(key);
            types.add(this.type(value));
        }
        this.printColumns(keys, types);
    }

    public void lang(String langName) {
        ScriptLanguage language = this.scriptService.getLanguageByName(langName);
        if (language == null) {
            this.out.println("No such language: " + langName);
            return;
        }
        this.lang(language);
        this.out.println("language -> " + this.interpreter.getLanguage().getLanguageName());
    }

    public void lang(ScriptLanguage language) {
        DefaultScriptInterpreter newInterpreter = new DefaultScriptInterpreter(language);
        try {
            this.copyBindings(this.interpreter, newInterpreter);
        }
        catch (Throwable t) {
            t.printStackTrace(this.out);
        }
        this.interpreter = newInterpreter;
    }

    public void langs() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> versions = new ArrayList<String>();
        ArrayList<List<String>> aliases = new ArrayList<List<String>>();
        for (ScriptLanguage lang : this.getInterpretedLanguages()) {
            names.add(lang.getLanguageName());
            versions.add(lang.getLanguageVersion());
            aliases.add(lang.getNames());
        }
        this.printColumns(names, versions, aliases);
    }

    public void debug() {
        this.debug = !this.debug;
        this.out.println("debug mode -> " + this.debug);
    }

    public static void main(String ... args) throws Exception {
        Context context = new Context();
        ScriptREPL scriptCLI = new ScriptREPL(context);
        scriptCLI.loop();
        context.dispose();
        System.exit(0);
    }

    private synchronized void initLanguages() {
        if (this.languages != null) {
            return;
        }
        ArrayList<ScriptLanguage> langs = new ArrayList<ScriptLanguage>();
        for (ScriptLanguage lang : this.scriptService.getLanguages()) {
            if (lang.isCompiledLanguage()) continue;
            langs.add(lang);
        }
        this.languages = langs;
    }

    private void populateBindings(Bindings bindings) {
        bindings.put("ctx", (Object)this.context);
        for (Service service : this.context.getServiceIndex().getAll()) {
            String name = this.serviceName(service);
            bindings.put(name, (Object)service);
        }
        for (Gateway gateway : this.gateways()) {
            bindings.put(gateway.getShortName(), (Object)gateway);
        }
    }

    private void copyBindings(ScriptInterpreter src, ScriptInterpreter dest) {
        if (src == null) {
            return;
        }
        Bindings srcBindings = src.getBindings();
        Bindings destBindings = dest.getBindings();
        for (String key : src.getBindings().keySet()) {
            Object value = src.getLanguage().decode(srcBindings.get(key));
            destBindings.put(key, value);
        }
    }

    private List<Gateway> gateways() {
        ArrayList<Gateway> gateways = new ArrayList<Gateway>();
        if (this.pluginService == null) {
            return gateways;
        }
        List<PluginInfo<Gateway>> infos = this.pluginService.getPluginsOfType(Gateway.class);
        for (PluginInfo<Gateway> info : infos) {
            try {
                Constructor<Gateway> ctor = info.loadClass().getConstructor(Context.class);
                Gateway gateway = ctor.newInstance(this.context);
                gateways.add(gateway);
            }
            catch (Throwable t) {
                t.printStackTrace(this.out);
            }
        }
        return gateways;
    }

    private String serviceName(Service service) {
        String serviceName = service.getClass().getSimpleName();
        String shortName = ScriptREPL.lowerCamelCase(serviceName.replaceAll("^(Default)?(.*)Service$", "$2"));
        return shortName;
    }

    private String type(Object value) {
        if (value == null) {
            return NULL;
        }
        Object decoded = this.interpreter.getLanguage().decode(value);
        if (decoded == null) {
            return NULL;
        }
        return "[" + decoded.getClass().getName() + "]";
    }

    private void printColumns(List<?> ... columns) {
        int pad = 2;
        int[] widths = new int[columns.length];
        for (int c = 0; c < columns.length; ++c) {
            List<?> list = columns[c];
            for (Object o : list) {
                String s = ScriptREPL.s(o);
                if (s.length() <= widths[c]) continue;
                widths[c] = s.length();
            }
        }
        for (int i = 0; i < columns[0].size(); ++i) {
            for (int c = 0; c < columns.length; ++c) {
                String s = ScriptREPL.s(columns[c].get(i));
                this.out.print(s);
                for (int p = s.length(); p < widths[c] + 2; ++p) {
                    this.out.print(' ');
                }
            }
            this.out.println();
        }
    }

    private static String lowerCamelCase(String s) {
        char c;
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length() && (c = sb.charAt(i)) >= 'A' && c <= 'Z'; ++i) {
            sb.setCharAt(i, (char)(c - 65 + 97));
        }
        return sb.toString();
    }

    private static String s(Object o) {
        return o == null ? NULL : o.toString();
    }
}

