/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.scijava.convert.NumberToNumberConverter;
import org.scijava.util.Types;

public abstract class AbstractNumberConverterTests {
    protected NumberToNumberConverter<?, ?> converter = this.getConverter();
    protected Class<?> srcType = this.converter.getInputType();
    protected Class<?> destType = this.converter.getOutputType();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    public abstract Number getSrc();

    public abstract NumberToNumberConverter<?, ?> getConverter();

    public abstract Number getExpectedValue();

    public abstract Number getInvalidInput();

    public abstract Class<?> getInvalidOutput();

    @Test
    public void testWrapper() {
        Number src = this.getSrc();
        Number expect = this.getExpectedValue();
        Assert.assertTrue((boolean)this.destType.isInstance(this.converter.convert((Object)src, this.destType)));
        Assert.assertEquals((Object)expect, (Object)this.converter.convert((Object)src, this.destType));
    }

    @Test
    public void testPrimitive() {
        Number src = this.getSrc();
        Number expect = this.getExpectedValue();
        Assert.assertEquals((Object)expect, (Object)this.converter.convert((Object)src, Types.unbox(this.destType)));
    }

    @Test
    public void nullInput() {
        this.iae("Null input", null, null);
    }

    @Test
    public void incorrectInputType() {
        Number input = this.getInvalidInput();
        String message = "Expected input of type " + this.srcType.getSimpleName() + ", but got " + input.getClass().getSimpleName();
        this.iae(message, input, this.destType);
    }

    @Test
    public void incorrectOutputType() {
        Class<?> output = this.getInvalidOutput();
        Number src = this.getSrc();
        String message = "Expected output class of " + this.destType.getSimpleName() + ", but got " + output.getSimpleName();
        this.iae(message, src, output);
    }

    protected void iae(String message, Number src, Class<?> dest) {
        this.exception(IllegalArgumentException.class, message, src, dest);
    }

    protected void exception(Class<? extends Throwable> excType, String message, Number src, Class<?> dest) {
        this.exception.expect(excType);
        this.exception.expectMessage(message);
        this.converter.convert((Object)src, dest);
    }
}

