/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.scijava.Context;
import org.scijava.Contextual;
import org.scijava.NullContextException;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.module.AbstractModule;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptInfo;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.script.process.ScriptCallback;

public class ScriptModule
extends AbstractModule
implements Contextual {
    public static final String RETURN_VALUE = "result";
    private final ScriptInfo info;
    @Parameter
    private Context context;
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private ConvertService conversionService;
    @Parameter
    private LogService log;
    private ScriptEngine scriptEngine;
    private Writer output;
    private Writer error;
    private Object returnValue;

    public ScriptModule(ScriptInfo info) {
        this.info = info;
    }

    public void setOutputWriter(Writer output) {
        this.output = output;
    }

    public void setErrorWriter(Writer error) {
        this.error = error;
    }

    public ScriptEngine getEngine() {
        if (this.scriptEngine == null) {
            this.scriptEngine = this.getInfo().getLanguage().getScriptEngine();
        }
        return this.scriptEngine;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    @Override
    public ScriptInfo getInfo() {
        return this.info;
    }

    @Override
    public void run() {
        PrintWriter errorPrinter;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            Thread.currentThread().setContextClassLoader(Context.getClassLoader());
        }
        ScriptEngine engine = this.getEngine();
        String path = this.getInfo().getPath();
        engine.put("javax.script.filename", path);
        engine.put(ScriptModule.class.getName(), this);
        ScriptContext scriptContext = engine.getContext();
        if (this.output != null) {
            scriptContext.setWriter(this.output);
        }
        if (this.error != null) {
            scriptContext.setErrorWriter(this.error);
            errorPrinter = new PrintWriter(this.error);
        } else {
            errorPrinter = null;
        }
        for (ModuleItem<?> moduleItem : this.getInfo().inputs()) {
            String string = moduleItem.getName();
            engine.put(string, this.getInput(string));
        }
        this.returnValue = null;
        try {
            for (ScriptCallback scriptCallback : this.getInfo().callbacks()) {
                scriptCallback.invoke(this);
            }
            this.returnValue = engine.eval(this.getInfo().getProcessedScript());
        }
        catch (Throwable e) {
            while (e instanceof ScriptException && e.getCause() != null) {
                e = e.getCause();
            }
            if (this.error == null) {
                this.log.error(e);
            }
            e.printStackTrace(errorPrinter);
        }
        ScriptLanguage language = this.getInfo().getLanguage();
        for (ModuleItem<?> moduleItem : this.getInfo().outputs()) {
            String name = moduleItem.getName();
            Object value = RETURN_VALUE.equals(name) && this.getInfo().isReturnValueAppended() ? this.returnValue : engine.get(name);
            Object decoded = language.decode(value);
            Object typed = this.conversionService.convert(decoded, moduleItem.getType());
            this.setOutput(name, typed);
        }
        if (this.output != null) {
            try {
                this.output.flush();
            }
            catch (IOException iOException) {
                if (this.error == null) {
                    this.log.error(iOException);
                }
                iOException.printStackTrace(errorPrinter);
            }
        }
        if (errorPrinter != null) {
            errorPrinter.flush();
        }
    }

    @Override
    public Context context() {
        if (this.context == null) {
            throw new NullContextException();
        }
        return this.context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        context.inject(this);
    }

    @Deprecated
    public ScriptLanguage getLanguage() {
        return this.getInfo().getLanguage();
    }

    @Deprecated
    public void setLanguage(ScriptLanguage scriptLanguage) {
        this.getInfo().setLanguage(scriptLanguage);
    }
}

