/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.log.DefaultLogger;
import org.scijava.log.LogListener;
import org.scijava.log.LogSource;
import org.scijava.log.Logger;
import org.scijava.log.TestLogListener;

public class DefaultLoggerTest {
    private Logger logger;
    private TestLogListener listener;

    @Before
    public void setup() {
        this.logger = new DefaultLogger(message -> {}, LogSource.newRoot(), 3);
        this.listener = new TestLogListener();
        this.logger.addLogListener((LogListener)this.listener);
    }

    @Test
    public void test() {
        this.listener.clear();
        this.logger.error((Object)"Hello World!");
        Assert.assertTrue((boolean)this.listener.hasLogged(m -> m.text().equals("Hello World!")));
        Assert.assertTrue((boolean)this.listener.hasLogged(m -> m.level() == 1));
    }

    @Test
    public void testSubLogger() {
        this.listener.clear();
        Logger sub = this.logger.subLogger("sub");
        sub.error((Object)"Hello World!");
        Assert.assertTrue((boolean)this.listener.hasLogged(m -> m.source().path().contains("sub")));
    }

    @Test
    public void testHierarchicLogger() {
        this.listener.clear();
        Logger subA = this.logger.subLogger("subA");
        Logger subB = subA.subLogger("subB");
        subB.error((Object)"Hello World!");
        Assert.assertTrue((boolean)this.listener.hasLogged(m -> m.source().equals(subB.getSource())));
        Assert.assertEquals(Arrays.asList("subA"), (Object)subA.getSource().path());
        Assert.assertEquals(Arrays.asList("subA", "subB"), (Object)subB.getSource().path());
    }

    @Test
    public void testLogForwarding() {
        this.listener.clear();
        Logger sub = this.logger.subLogger("xyz");
        TestLogListener subListener = new TestLogListener();
        sub.addLogListener((LogListener)subListener);
        sub.error((Object)"Hello World!");
        this.logger.error((Object)"Goodbye!");
        Assert.assertTrue((boolean)subListener.hasLogged(m -> m.text().equals("Hello World!")));
        Assert.assertFalse((boolean)subListener.hasLogged(m -> m.text().equals("Goodbye!")));
        Assert.assertTrue((boolean)this.listener.hasLogged(m -> m.text().equals("Hello World!")));
        Assert.assertTrue((boolean)this.listener.hasLogged(m -> m.text().equals("Goodbye!")));
    }
}

