/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.app.AppService;
import org.scijava.app.StatusService;
import org.scijava.app.event.StatusEvent;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.display.event.DisplayActivatedEvent;
import org.scijava.display.event.DisplayCreatedEvent;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.display.event.DisplayUpdatedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.platform.event.AppQuitEvent;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.StatusBar;
import org.scijava.ui.UIService;
import org.scijava.ui.UserInterface;
import org.scijava.ui.event.UIShownEvent;
import org.scijava.ui.viewer.DisplayViewer;

@Plugin(type=Service.class)
public final class DefaultUIService
extends AbstractService
implements UIService {
    @Parameter
    private LogService log;
    @Parameter
    private EventService eventService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private AppService appService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private DisplayService displayService;
    private List<DisplayViewer<?>> displayViewers;
    private List<UserInterface> uiList;
    private Map<String, UserInterface> uiMap;
    private boolean initialized;
    private boolean disposed;
    private UserInterface defaultUI;
    private boolean forceHeadless;
    private boolean activationInvocationPending = false;

    @Override
    public void addUI(UserInterface ui) {
        this.addUI(null, ui);
    }

    @Override
    public void addUI(String name, UserInterface ui) {
        if (!this.initialized) {
            this.discoverUIs();
        }
        this.addUserInterface(name, ui);
    }

    @Override
    public void showUI() {
        if (this.disposed) {
            return;
        }
        UserInterface ui = this.getDefaultUI();
        if (ui == null) {
            throw new IllegalStateException("No UIs available. Please add a component containing a UIPlugin (e.g., scijava-ui-swing) to your class-path.");
        }
        this.showUI(ui);
    }

    @Override
    public void showUI(String name) {
        UserInterface ui = this.uiMap().get(name);
        if (ui == null) {
            throw new IllegalArgumentException("No such user interface: " + name);
        }
        this.showUI(ui);
    }

    @Override
    public void showUI(UserInterface ui) {
        this.log.debug("Launching user interface: " + ui.getClass().getName());
        ui.show();
        for (Display<?> display : this.displayService.getDisplays()) {
            ui.show(display);
        }
        this.eventService.publish(new UIShownEvent(ui));
    }

    @Override
    public boolean isVisible() {
        UserInterface ui = this.getDefaultUI();
        if (ui == null) {
            return false;
        }
        return ui.isVisible();
    }

    @Override
    public boolean isVisible(String name) {
        UserInterface ui = this.uiMap().get(name);
        return ui != null && ui.isVisible();
    }

    @Override
    public void setHeadless(boolean headless) {
        this.forceHeadless = headless;
    }

    @Override
    public boolean isHeadless() {
        return this.forceHeadless || Boolean.getBoolean("java.awt.headless") || GraphicsEnvironment.isHeadless();
    }

    @Override
    public UserInterface getDefaultUI() {
        if (!this.initialized) {
            this.discoverUIs();
        }
        if (this.isHeadless()) {
            return this.uiMap().get("headless");
        }
        if (this.defaultUI != null) {
            return this.defaultUI;
        }
        return this.uiList().isEmpty() ? null : this.uiList().get(0);
    }

    @Override
    public void setDefaultUI(UserInterface ui) {
        this.defaultUI = ui;
    }

    @Override
    public boolean isDefaultUI(String name) {
        return this.getDefaultUI() == this.getUI(name);
    }

    @Override
    public UserInterface getUI(String name) {
        return this.uiMap().get(name);
    }

    @Override
    public List<UserInterface> getAvailableUIs() {
        return Collections.unmodifiableList(this.uiList());
    }

    @Override
    public List<UserInterface> getVisibleUIs() {
        ArrayList<UserInterface> uis = new ArrayList<UserInterface>();
        for (UserInterface ui : this.uiList()) {
            if (!ui.isVisible()) continue;
            uis.add(ui);
        }
        return uis;
    }

    @Override
    public List<PluginInfo<DisplayViewer<?>>> getViewerPlugins() {
        List<PluginInfo<DisplayViewer<?>>> viewers = this.pluginService.getPluginsOfType(DisplayViewer.class);
        return viewers;
    }

    @Override
    public void show(Object o) {
        this.getVisibleUI(true).show(o);
    }

    @Override
    public void show(String name, Object o) {
        this.getVisibleUI(true).show(name, o);
    }

    @Override
    public void show(Display<?> display) {
        this.getVisibleUI(true).show(display);
    }

    @Override
    public void addDisplayViewer(DisplayViewer<?> viewer) {
        this.displayViewers().add(viewer);
    }

    @Override
    public DisplayViewer<?> getDisplayViewer(Display<?> display) {
        for (DisplayViewer<?> displayViewer : this.displayViewers()) {
            if (displayViewer.getDisplay() != display) continue;
            return displayViewer;
        }
        return null;
    }

    @Override
    public DialogPrompt.Result showDialog(String message) {
        return this.showDialog(message, this.getTitle());
    }

    @Override
    public DialogPrompt.Result showDialog(String message, DialogPrompt.MessageType messageType) {
        return this.showDialog(message, this.getTitle(), messageType);
    }

    @Override
    public DialogPrompt.Result showDialog(String message, DialogPrompt.MessageType messageType, DialogPrompt.OptionType optionType) {
        return this.showDialog(message, this.getTitle(), messageType, optionType);
    }

    @Override
    public DialogPrompt.Result showDialog(String message, String title) {
        return this.showDialog(message, title, DialogPrompt.MessageType.INFORMATION_MESSAGE);
    }

    @Override
    public DialogPrompt.Result showDialog(String message, String title, DialogPrompt.MessageType messageType) {
        return this.showDialog(message, title, messageType, DialogPrompt.OptionType.DEFAULT_OPTION);
    }

    @Override
    public DialogPrompt.Result showDialog(String message, String title, DialogPrompt.MessageType messageType, DialogPrompt.OptionType optionType) {
        UserInterface ui = this.getVisibleUI(false);
        if (ui == null) {
            return null;
        }
        DialogPrompt dialogPrompt = ui.dialogPrompt(message, title, messageType, optionType);
        return dialogPrompt == null ? null : dialogPrompt.prompt();
    }

    @Override
    public File chooseFile(File file, String style) {
        UserInterface ui = this.getVisibleUI(true);
        return ui == null ? null : ui.chooseFile(file, style);
    }

    @Override
    public File chooseFile(String title, File file, String style) {
        UserInterface ui = this.getVisibleUI(true);
        return ui == null ? null : ui.chooseFile(title, file, style);
    }

    @Override
    public File[] chooseFiles(File parent, File[] files, FileFilter filter, String style) {
        UserInterface ui = this.getVisibleUI(true);
        return ui == null ? null : ui.chooseFiles(parent, files, filter, style);
    }

    @Override
    public List<File> chooseFiles(File parent, List<File> fileList, FileFilter filter, String style) {
        UserInterface ui = this.getVisibleUI(true);
        return ui == null ? null : ui.chooseFiles(parent, fileList, filter, style);
    }

    @Override
    public void showContextMenu(String menuRoot, Display<?> display, int x, int y) {
        UserInterface ui = this.getVisibleUI(true);
        if (ui != null) {
            ui.showContextMenu(menuRoot, display, x, y);
        }
    }

    @Override
    public String getStatusMessage(StatusEvent statusEvent) {
        String appName = this.appService.getApp().getInfo().getName();
        return this.statusService.getStatusMessage(appName, statusEvent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void dispose() {
        void var3_5;
        ArrayList viewers = new ArrayList();
        viewers.addAll(this.displayViewers());
        for (DisplayViewer displayViewer : viewers) {
            displayViewer.dispose();
        }
        List<UserInterface> uis = this.getAvailableUIs();
        int n = uis.size() - 1;
        while (var3_5 >= 0) {
            uis.get((int)var3_5).dispose();
            --var3_5;
        }
        this.disposed = true;
    }

    @EventHandler
    protected void onEvent(DisplayCreatedEvent e) {
        Object display = e.getObject();
        for (UserInterface ui : this.getVisibleUIs()) {
            ui.show((Display<?>)display);
        }
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent e) {
        Object display = e.getObject();
        DisplayViewer<?> displayViewer = this.getDisplayViewer((Display<?>)display);
        if (displayViewer != null) {
            displayViewer.onDisplayDeletedEvent(e);
            this.displayViewers().remove(displayViewer);
        }
    }

    @EventHandler
    protected void onEvent(DisplayUpdatedEvent e) {
        Display<?> display = e.getDisplay();
        DisplayViewer<?> displayViewer = this.getDisplayViewer(display);
        if (displayViewer != null) {
            displayViewer.onDisplayUpdatedEvent(e);
        }
    }

    @EventHandler
    protected void onEvent(final DisplayActivatedEvent e) {
        if (this.activationInvocationPending) {
            return;
        }
        this.activationInvocationPending = true;
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                DisplayViewer<?> displayViewer;
                Display<?> activeDisplay = DefaultUIService.this.displayService.getActiveDisplay();
                if (activeDisplay != null && (displayViewer = DefaultUIService.this.getDisplayViewer(activeDisplay)) != null) {
                    displayViewer.onDisplayActivatedEvent(e);
                }
                DefaultUIService.this.activationInvocationPending = false;
            }
        });
    }

    @EventHandler
    protected synchronized void onEvent(AppQuitEvent event) {
        if (!this.initialized) {
            return;
        }
        for (UserInterface ui : this.getVisibleUIs()) {
            ui.saveLocation();
        }
    }

    @EventHandler
    protected void onEvent(StatusEvent event) {
        if (event.isWarning()) {
            String message = event.getStatusMessage();
            if (message != null && !message.isEmpty()) {
                this.showDialog(message, DialogPrompt.MessageType.WARNING_MESSAGE);
            }
        } else {
            int val = event.getProgressValue();
            int max = event.getProgressMaximum();
            String message = this.getStatusMessage(event);
            if (max < 0 && message == null) {
                return;
            }
            for (UserInterface ui : this.getAvailableUIs()) {
                StatusBar statusBar = ui.getStatusBar();
                if (statusBar == null) continue;
                if (max >= 0) {
                    statusBar.setProgress(val, max);
                }
                if (message == null) continue;
                statusBar.setStatus(message);
            }
        }
    }

    private List<DisplayViewer<?>> displayViewers() {
        if (!this.initialized) {
            this.discoverUIs();
        }
        return this.displayViewers;
    }

    private List<UserInterface> uiList() {
        if (!this.initialized) {
            this.discoverUIs();
        }
        return this.uiList;
    }

    private Map<String, UserInterface> uiMap() {
        if (!this.initialized) {
            this.discoverUIs();
        }
        return this.uiMap;
    }

    private synchronized void discoverUIs() {
        if (this.initialized) {
            return;
        }
        this.displayViewers = new ArrayList();
        this.uiList = new ArrayList<UserInterface>();
        this.uiMap = new HashMap<String, UserInterface>();
        List<PluginInfo<UserInterface>> infos = this.pluginService.getPluginsOfType(UserInterface.class);
        for (PluginInfo<UserInterface> info : infos) {
            UserInterface ui = this.pluginService.createInstance(info);
            if (ui == null) continue;
            this.log.debug("Discovered user interface: " + ui.getClass().getName());
            this.addUserInterface(info.getName(), ui);
        }
        String uiProp = System.getProperty("scijava.ui");
        UserInterface ui = this.uiMap.get(uiProp);
        if (ui != null) {
            this.setDefaultUI(ui);
        }
        this.initialized = true;
    }

    private void addUserInterface(String name, UserInterface ui) {
        this.uiList.add(ui);
        this.uiMap.put(ui.getClass().getName(), ui);
        if (name != null && !name.isEmpty()) {
            this.uiMap.put(name, ui);
        }
    }

    private String getTitle() {
        return this.appService.getApp().getTitle();
    }

    private UserInterface getVisibleUI(boolean forceShow) {
        UserInterface defaultUI = this.getDefaultUI();
        if (defaultUI == null) {
            return null;
        }
        if (defaultUI.isVisible()) {
            return defaultUI;
        }
        if (this.getVisibleUIs().size() > 0) {
            return this.getVisibleUIs().get(0);
        }
        if (forceShow) {
            this.showUI(defaultUI);
            return defaultUI;
        }
        return null;
    }
}

