/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import java.util.ArrayList;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.log.AbstractLogService;
import org.scijava.log.LogLevel;
import org.scijava.log.LogMessage;
import org.scijava.log.LogService;
import org.scijava.log.Logger;
import org.scijava.log.TestLogListener;

public class LogServiceTest {
    @Test
    public void testGetPrefix() {
        TestableLogService logService = new TestableLogService();
        Assert.assertEquals((Object)"[ERROR]", (Object)logService.getPrefix(1));
        Assert.assertEquals((Object)"[TRACE]", (Object)logService.getPrefix(5));
    }

    @Test
    public void testCompleteLogMethod() {
        this.testCompleteLogMethod("ERROR", (logService, msg, t) -> logService.error(msg, t));
        this.testCompleteLogMethod("WARN", (logService, msg, t) -> logService.warn(msg, t));
        this.testCompleteLogMethod("INFO", (logService, msg, t) -> logService.info(msg, t));
        this.testCompleteLogMethod("DEBUG", (logService, msg, t) -> logService.debug(msg, t));
        this.testCompleteLogMethod("TRACE", (logService, msg, t) -> logService.trace(msg, t));
    }

    @Test
    public void testMessageLogMethod() {
        this.testMessageLogMethod("ERROR", (logService, msg) -> logService.error(msg));
        this.testMessageLogMethod("WARN", (logService, msg) -> logService.warn(msg));
        this.testMessageLogMethod("INFO", (logService, msg) -> logService.info(msg));
        this.testMessageLogMethod("DEBUG", (logService, msg) -> logService.debug(msg));
        this.testMessageLogMethod("TRACE", (logService, msg) -> logService.trace(msg));
    }

    @Test
    public void testExceptionLogMethod() {
        this.testExceptionLogMethod("ERROR", (logService, t) -> logService.error(t));
        this.testExceptionLogMethod("WARN", (logService, t) -> logService.warn(t));
        this.testExceptionLogMethod("INFO", (logService, t) -> logService.info(t));
        this.testExceptionLogMethod("DEBUG", (logService, t) -> logService.debug(t));
        this.testExceptionLogMethod("TRACE", (logService, t) -> logService.trace(t));
    }

    private void testCompleteLogMethod(String prefix, LogMethodCall logMethodCall) {
        this.testLogMethod(prefix, logMethodCall, true, true);
    }

    private void testMessageLogMethod(String prefix, BiConsumer<LogService, Object> call) {
        this.testLogMethod(prefix, (log, text, exception) -> call.accept(log, text), true, false);
    }

    private void testExceptionLogMethod(String prefix, BiConsumer<LogService, Throwable> call) {
        this.testLogMethod(prefix, (log, text, exception) -> call.accept(log, exception), false, true);
    }

    private void testLogMethod(String prefix, LogMethodCall logMethodCall, boolean testMessage, boolean testException) {
        TestableLogService logService = new TestableLogService();
        logService.setLevel(5);
        String text = "Message";
        NullPointerException exception = new NullPointerException();
        logMethodCall.run((LogService)logService, text, exception);
        if (testMessage) {
            Assert.assertTrue((boolean)logService.message().contains(prefix));
            Assert.assertTrue((boolean)logService.message().contains(text));
        }
        if (testException) {
            Assert.assertEquals((Object)exception, (Object)logService.exception());
        }
    }

    @Test
    public void testSetLevel() {
        TestableLogService logService = new TestableLogService();
        logService.setLevel(5);
        Assert.assertEquals((long)5L, (long)logService.getLevel());
        logService.setLevel(1);
        Assert.assertEquals((long)1L, (long)logService.getLevel());
    }

    @Test
    public void testSetClassSpecificLevel() {
        TestableLogService logService = new TestableLogService();
        MyTestClass testClass = new MyTestClass((LogService)logService);
        logService.setLevel(1);
        logService.setLevel(MyTestClass.class.getName(), 5);
        Assert.assertEquals((long)1L, (long)logService.getLevel());
        Assert.assertEquals((long)5L, (long)testClass.getLevel());
    }

    @Test
    public void testIsWarn() {
        this.testIsLevel(1, Logger::isError);
        this.testIsLevel(2, Logger::isWarn);
        this.testIsLevel(3, Logger::isInfo);
        this.testIsLevel(4, Logger::isDebug);
        this.testIsLevel(5, Logger::isTrace);
    }

    private void testIsLevel(int level, Function<LogService, Boolean> isLevel) {
        TestableLogService logService = new TestableLogService();
        logService.setLevel(0);
        Assert.assertFalse((boolean)isLevel.apply((LogService)logService));
        logService.setLevel(level);
        Assert.assertTrue((boolean)isLevel.apply((LogService)logService));
        logService.setLevel(5);
        Assert.assertTrue((boolean)isLevel.apply((LogService)logService));
    }

    @Test
    public void testDefaultLevel() {
        Assert.assertEquals((long)3L, (long)new TestableLogService().getLevel());
    }

    @Test
    public void testMainSystemProperty() {
        Properties properties = new Properties();
        properties.setProperty("scijava.log.level", "error");
        int level = new TestableLogService(properties).getLevel();
        Assert.assertEquals((long)1L, (long)level);
    }

    @Test
    public void testClassLogLevel() {
        TestableLogService log = new TestableLogService();
        log.setLevel(4);
        log.setLevel(Dummy.class.getName(), 1);
        int level = Dummy.getLevel((LogService)log);
        Assert.assertEquals((long)1L, (long)level);
    }

    @Test
    public void testClassLogLevelViaProperties() {
        Properties properties = new Properties();
        properties.setProperty("scijava.log.level:" + Dummy.class.getName(), LogLevel.prefix((int)1));
        properties.setProperty("scijava.log.level:" + this.getClass().getName(), LogLevel.prefix((int)5));
        TestableLogService log = new TestableLogService(properties);
        log.setLevel(4);
        int level = Dummy.getLevel((LogService)log);
        Assert.assertEquals((long)1L, (long)level);
    }

    @Test
    public void testSubLoggerLogLevel() {
        TestableLogService log = new TestableLogService();
        log.setLevel(1);
        log.setLevelForLogger("foo:bar", 5);
        Logger sub = log.subLogger("foo").subLogger("bar");
        Assert.assertEquals((long)5L, (long)sub.getLevel());
    }

    @Test
    public void testSubLoggerLogLevelViaProperties() {
        Properties properties = new Properties();
        properties.setProperty("scijava.log.level.source:Hello:World", LogLevel.prefix((int)1));
        properties.setProperty("scijava.log.level.source:foo:bar", LogLevel.prefix((int)5));
        TestableLogService log = new TestableLogService(properties);
        Logger sub = log.subLogger("foo").subLogger("bar");
        Assert.assertEquals((long)5L, (long)sub.getLevel());
    }

    @Test
    public void testPackageLogLevel() {
        TestableLogService log = new TestableLogService();
        log.setLevel("org.scijava.log", 5);
        log.setLevel("xyz.foo.bar", 1);
        int level = log.getLevel();
        Assert.assertEquals((long)5L, (long)level);
    }

    @Test
    public void testListener() {
        TestableLogService logService = new TestableLogService();
        TestLogListener listener = new TestLogListener();
        String msg1 = "Hello World!";
        String msg2 = "foo bar";
        logService.addLogListener(listener);
        logService.error(msg1);
        logService.subLogger("xyz").debug((Object)msg2);
        listener.hasLogged(m -> msg1.equals(m.text()));
        listener.hasLogged(m -> msg2.equals(m.text()));
    }

    @Test
    public void testLogListenerIsNotifiedOnce() {
        ArrayList list = new ArrayList();
        TestableLogService logService = new TestableLogService();
        logService.addLogListener(list::add);
        logService.error("dummy");
        Assert.assertEquals((long)1L, (long)list.size());
    }

    private static class TestableLogService
    extends AbstractLogService {
        String message = null;
        Throwable exception = null;

        public TestableLogService() {
            this(new Properties());
        }

        public TestableLogService(Properties properties) {
            super(properties);
        }

        public String message() {
            return this.message;
        }

        public Throwable exception() {
            return this.exception;
        }

        protected void messageLogged(LogMessage message) {
            this.message = message.toString();
            this.exception = message.throwable();
        }
    }

    private static interface LogMethodCall {
        public void run(LogService var1, Object var2, Throwable var3);
    }

    private static class MyTestClass {
        private final LogService log;

        MyTestClass(LogService log) {
            this.log = log;
        }

        int getLevel() {
            return this.log.getLevel();
        }
    }

    static class Dummy {
        Dummy() {
        }

        public static int getLevel(LogService log) {
            return log.getLevel();
        }
    }
}

