/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.object.ObjectService;
import org.scijava.plugin.AbstractPTService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SingletonPlugin;
import org.scijava.plugin.SingletonService;
import org.scijava.plugin.event.PluginsAddedEvent;
import org.scijava.plugin.event.PluginsRemovedEvent;

public abstract class AbstractSingletonService<PT extends SingletonPlugin>
extends AbstractPTService<PT>
implements SingletonService<PT> {
    @Parameter
    private LogService log;
    @Parameter
    private ObjectService objectService;
    private List<PT> instances;
    private Map<Class<? extends PT>, PT> instanceMap;

    @Override
    public ObjectService objectService() {
        return this.objectService;
    }

    @Override
    public List<PT> getInstances() {
        if (this.instances == null) {
            this.initInstances();
        }
        return Collections.unmodifiableList(this.instances);
    }

    @Override
    public <P extends PT> P getInstance(Class<P> pluginClass) {
        if (this.instanceMap == null) {
            this.initInstances();
        }
        return (P)((SingletonPlugin)this.instanceMap.get(pluginClass));
    }

    @EventHandler
    protected void onEvent(PluginsRemovedEvent event) {
        if (this.instanceMap == null) {
            return;
        }
        for (PluginInfo info : event.getItems()) {
            SingletonPlugin obj = (SingletonPlugin)this.instanceMap.remove(info.getPluginClass());
            if (obj == null) continue;
            this.instances.remove(obj);
            this.objectService.removeObject(obj);
        }
    }

    @EventHandler
    protected void onEvent(PluginsAddedEvent event) {
        Class<?> pluginClass;
        SingletonPlugin plugin;
        if (this.instanceMap == null) {
            return;
        }
        ArrayList singletons = new ArrayList();
        for (PluginInfo pluginInfo : event.getItems()) {
            if (!this.getPluginType().isAssignableFrom(pluginInfo.getPluginType())) continue;
            plugin = (SingletonPlugin)this.pluginService().createInstance(pluginInfo);
            pluginClass = plugin.getClass();
            this.instanceMap.put(pluginClass, plugin);
            this.instances.add(plugin);
        }
        for (PluginInfo pluginInfo : singletons) {
            plugin = (SingletonPlugin)this.pluginService().createInstance(pluginInfo);
            pluginClass = plugin.getClass();
            this.instanceMap.put(pluginClass, plugin);
            this.instances.add(plugin);
        }
    }

    private synchronized void initInstances() {
        if (this.instances != null) {
            return;
        }
        List list = this.filterInstances(this.pluginService().createInstancesOfType(this.getPluginType()));
        HashMap<Class<PT>, PT> map = new HashMap<Class<PT>, PT>();
        for (SingletonPlugin plugin : list) {
            Class<?> ptClass = plugin.getClass();
            map.put(ptClass, plugin);
        }
        this.log.debug("Found " + list.size() + " " + this.getPluginType().getSimpleName() + " plugins.");
        this.instanceMap = map;
        this.instances = list;
    }
}

