/*
 * #%L
 * SciJava Common shared library for SciJava software.
 * %%
 * Copyright (C) 2009 - 2025 SciJava developers.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

package org.scijava.plugin;

import org.scijava.Contextual;
import org.scijava.Identifiable;
import org.scijava.Locatable;
import org.scijava.Prioritized;
import org.scijava.Versioned;
import org.scijava.log.LogService;
import org.scijava.log.Logged;

/**
 * Base interface for {@link Contextual}, {@link Prioritized} plugins that
 * retain access to their associated {@link PluginInfo} metadata via the
 * {@link HasPluginInfo} interface. This interface is intended as a convenient
 * extension point for new types of plugins.
 * 
 * @author Curtis Rueden
 */
public interface RichPlugin extends SciJavaPlugin, Contextual, Prioritized,
	HasPluginInfo, Logged, Identifiable, Locatable, Versioned
{

	// -- Identifiable methods --

	@Override
	default String getIdentifier() {
		return "plugin:" + getClass().getName();
	}

	// -- Logged methods --

	@Override
	default LogService log() {
		return context().getService(LogService.class);
	}
}
