/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.scijava.maven.plugin.SnapshotException;

public class SnapshotFinder {
    private static final String PARENT_FLAG = "BAD PARENT";
    private List remoteRepositories;
    private Log log = null;
    private boolean foundSnapshot = false;
    private Map<String, Set<String>> badGavs = new LinkedHashMap<String, Set<String>>();
    private final MavenProjectBuilder projectBuilder;
    private final ArtifactRepository localRepository;
    private final Boolean failEarly;
    private final Boolean verbose;
    private final Set<String> groupIds = new HashSet<String>();

    public SnapshotFinder(MavenProjectBuilder projectBuilder, ArtifactRepository localRepository) {
        this(projectBuilder, localRepository, false);
    }

    public SnapshotFinder(MavenProjectBuilder projectBuilder, ArtifactRepository localRepository, Boolean failEarly) {
        this(projectBuilder, localRepository, failEarly, false);
    }

    public SnapshotFinder(MavenProjectBuilder projectBuilder, ArtifactRepository localRepository, Boolean failEarly, Boolean verbose) {
        this(projectBuilder, localRepository, failEarly, verbose, null);
    }

    public SnapshotFinder(MavenProjectBuilder projectBuilder, ArtifactRepository localRepository, Boolean failEarly, Boolean verbose, List groupIds) {
        this.projectBuilder = projectBuilder;
        this.localRepository = localRepository;
        this.failEarly = failEarly;
        this.verbose = verbose;
        if (groupIds != null) {
            for (int i = 0; i < groupIds.size(); ++i) {
                this.groupIds.add((String)groupIds.get(i));
            }
        }
    }

    public void checkProject(MavenProject project) throws SnapshotException {
        this.remoteRepositories = project.getRemoteArtifactRepositories();
        HashSet<String> parentGavs = new HashSet<String>();
        String projectGav = this.gav(project);
        parentGavs.add(projectGav);
        this.checkProjectHelper(project, "\t" + projectGav, parentGavs, null);
        if (this.foundSnapshot) {
            if (!this.verbose.booleanValue()) {
                String errorMessage = "The following direct dependencies may cause unreproducible builds:\n";
                for (String directDep : this.badGavs.keySet()) {
                    errorMessage = errorMessage + "\n" + directDep;
                    for (String dep : this.badGavs.get(directDep)) {
                        errorMessage = errorMessage + "\n\t" + dep;
                    }
                    errorMessage = errorMessage + "\n";
                }
                errorMessage = errorMessage + "\nFor full inheritance trees, run with verbose flag.";
                this.error(errorMessage);
            }
            throw new SnapshotException("Found one or more SNAPSHOT couplings. See error log for more information.");
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private void debug(String message) {
        if (this.log != null) {
            this.log.debug((CharSequence)message);
        }
    }

    private void error(String message) {
        if (this.log != null) {
            this.log.error((CharSequence)message);
        }
    }

    private void checkProjectHelper(MavenProject project, String path, Set<String> parentGavs, String directDepGav) throws SnapshotException {
        this.checkParent(project, path, parentGavs, directDepGav);
        List dependencies = project.getDependencies();
        for (Dependency d : dependencies) {
            try {
                if (this.isRange(d.getVersion())) {
                    if (!this.checkGroupId(d.getGroupId())) continue;
                    if (this.verbose.booleanValue()) {
                        this.error("Dependency listed with version range: " + d + " of path:\n" + path);
                        continue;
                    }
                    this.flagProblem(directDepGav, this.gav(d));
                    continue;
                }
                DefaultArtifact a = new DefaultArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion((String)d.getVersion()), d.getScope(), d.getType(), d.getClassifier(), project.getArtifact().getArtifactHandler());
                MavenProject dep = this.projectBuilder.buildFromRepository((Artifact)a, this.remoteRepositories, this.localRepository);
                String depGav = this.gav(dep);
                if (parentGavs.contains(depGav)) continue;
                this.debug("Checking gav: " + depGav);
                parentGavs.add(depGav);
                String depPath = this.makePath(path, dep);
                this.debug("checking pom:\n" + depPath);
                if (dep.getVersion().contains("SNAPSHOT") && this.checkGroupId(dep)) {
                    this.setFailure("Found SNAPSHOT version:\n", path, depGav, directDepGav);
                }
                if (directDepGav == null) {
                    this.checkProjectHelper(dep, depPath, this.childGavs(parentGavs, depGav), depGav);
                    continue;
                }
                this.checkProjectHelper(dep, depPath, this.childGavs(parentGavs, depGav), directDepGav);
            }
            catch (ProjectBuildingException e) {
                if (!this.checkGroupId(d.getGroupId())) continue;
                if (this.verbose.booleanValue()) {
                    this.error("Could not resolve dependency: " + d + " of path:\n" + path);
                    continue;
                }
                this.flagProblem(directDepGav, this.gav(d));
            }
        }
    }

    private void checkParent(MavenProject pom, String path, Set<String> parentGavs, String directDepGav) throws SnapshotException {
        MavenProject parent;
        String nextGav;
        if (pom.hasParent() && !parentGavs.contains(nextGav = this.gav(parent = pom.getParent()))) {
            String parentPath = this.makePath(path, parent);
            this.debug("checking parent:\n" + parentPath);
            if (parent.getVersion().contains("SNAPSHOT") && this.checkGroupId(parent)) {
                this.setFailure("Found SNAPSHOT parent:\n", path, nextGav, directDepGav);
            }
            this.checkParent(parent, parentPath, this.childGavs(parentGavs, nextGav), directDepGav);
        }
    }

    private Set<String> childGavs(Set<String> parentGavs, String childGav) {
        HashSet<String> childGavs = new HashSet<String>(parentGavs);
        childGavs.add(childGav);
        return childGavs;
    }

    private boolean checkGroupId(MavenProject project) {
        return this.checkGroupId(project.getGroupId());
    }

    private boolean checkGroupId(String groupId) {
        return this.groupIds.isEmpty() || this.groupIds.contains(groupId);
    }

    private boolean isRange(String version) {
        return version.startsWith("[") || version.startsWith("(") || version.endsWith("]") || version.endsWith(")");
    }

    private String makePath(String path, MavenProject project) {
        return this.makePath(path, this.gav(project));
    }

    private String makePath(String path, String gav) {
        String newPath = "\t" + gav + "\n" + path;
        return newPath;
    }

    private String gav(MavenProject project) {
        return this.gav(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    private String gav(Dependency d) {
        return this.gav(d.getGroupId(), d.getArtifactId(), d.getVersion());
    }

    private String gav(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    private void setFailure(String message, String path, String gav, String directDepGav) throws SnapshotException {
        if (this.failEarly.booleanValue()) {
            throw new SnapshotException(message + this.makePath(path, gav) + "\n\nThere may be other failures but <failEarly> was set to true");
        }
        if (this.verbose.booleanValue()) {
            this.error(message + this.makePath(path, gav));
        } else {
            this.flagProblem(directDepGav, gav);
        }
        this.foundSnapshot = true;
    }

    private void flagProblem(String directDepGav, String gav) {
        if (directDepGav == null) {
            directDepGav = PARENT_FLAG;
        }
        if (this.badGavs.get(directDepGav) == null) {
            this.badGavs.put(directDepGav, new HashSet());
        }
        this.badGavs.get(directDepGav).add(gav);
    }
}

