/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.scijava.maven.plugin.SciJavaDependencyChecker;
import org.scijava.maven.plugin.SciJavaDependencyException;

public final class DependencyUtils {
    public static void checkDependencies(MavenProject mavenProject, ArtifactRepository artifactRepository, DependencyTreeBuilder dependencyTreeBuilder, SciJavaDependencyChecker ... checkers) throws SciJavaDependencyException {
        DependencyUtils.checkDependencies(mavenProject, artifactRepository, dependencyTreeBuilder, "runtime", checkers);
    }

    public static void checkDependencies(MavenProject mavenProject, ArtifactRepository artifactRepository, DependencyTreeBuilder dependencyTreeBuilder, String scope, SciJavaDependencyChecker ... checkers) throws SciJavaDependencyException {
        ArtifactFilter artifactFilter = DependencyUtils.createResolvingArtifactFilter(scope);
        try {
            DependencyNode root = dependencyTreeBuilder.buildDependencyTree(mavenProject, artifactRepository, artifactFilter);
            String failureMessage = "";
            for (SciJavaDependencyChecker checker : checkers) {
                if (!root.accept((DependencyNodeVisitor)checker)) continue;
                failureMessage = failureMessage + checker.makeExceptionMessage();
            }
            if (!failureMessage.isEmpty()) {
                throw new SciJavaDependencyException(failureMessage);
            }
        }
        catch (DependencyTreeBuilderException e) {
            throw new SciJavaDependencyException(e.getMessage());
        }
    }

    private static ArtifactFilter createResolvingArtifactFilter(String scope) {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new ScopeArtifactFilter(scope));
        return filter;
    }
}

