/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.scijava.maven.plugin.util.PomEditor;
import org.scijava.maven.plugin.util.VersionVisitor;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.version.Version;
import org.xml.sax.SAXException;

@Mojo(name="bump", requiresProject=true, requiresOnline=true)
public class BumpMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Component
    private RepositorySystem repositorySystem;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Parameter(defaultValue="${project.remoteRepositories}", required=true, readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;
    private static final String IMAGEJ_REPOSITORY_URL = "http://maven.imagej.net/content/groups/public";

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File file = this.project.getFile();
            PomEditor editor = new PomEditor(new FileInputStream(file), this.getLog());
            editor.visitVersions(new VersionVisitor(){

                @Override
                public String visit(String groupId, String artifactId, String version) throws MojoExecutionException {
                    return BumpMojo.this.latestVersion(groupId, artifactId);
                }
            });
            editor.write(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read POM", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Could not parse POM", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Could not parse POM", (Exception)e);
        }
        catch (XPathExpressionException e) {
            throw new MojoExecutionException("Could not extract information from POM", (Exception)e);
        }
    }

    private String latestVersion(String groupId, String artifactId) throws MojoExecutionException {
        VersionRangeRequest request = new VersionRangeRequest();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, null, "[0,)");
        request.setArtifact((Artifact)artifact);
        this.makeImageJRepositoryKnown();
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        repositories.addAll(this.remoteRepositories);
        request.setRepositories(repositories);
        try {
            VersionRangeResult result = this.repositorySystem.resolveVersionRange(this.repositorySystemSession, request);
            List list = result.getVersions();
            for (int i = list.size() - 1; i >= 0; --i) {
                String version = ((Version)list.get(i)).toString();
                if (version.endsWith("-SNAPSHOT")) continue;
                return version;
            }
            this.getLog().warn((CharSequence)("Found no candidates for " + groupId + ":" + artifactId + "; Skipping"));
            return null;
        }
        catch (VersionRangeResolutionException e) {
            throw new MojoExecutionException("Could not resolve version for " + groupId + ":" + artifactId, (Exception)((Object)e));
        }
    }

    private void makeImageJRepositoryKnown() throws MojoExecutionException {
        for (RemoteRepository repository : this.remoteRepositories) {
            String url = repository.getUrl();
            if (!IMAGEJ_REPOSITORY_URL.equals(url)) continue;
            return;
        }
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get("default");
        if (layout == null) {
            throw new MojoExecutionException((Object)"default", "Invalid repository layout", "Invalid repository layout: default");
        }
        RemoteRepository imagej = new RemoteRepository("imagej.public", "default", IMAGEJ_REPOSITORY_URL);
        this.remoteRepositories.add(imagej);
    }
}

