/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator;

import fit.Counts;
import fit.Fixture;
import fit.Parse;
import fit.decorator.FixtureDecorator;
import fit.decorator.FixtureDecoratorTestCase;
import fit.decorator.Loop;
import fit.decorator.TestFixture;
import fit.decorator.util.TestCaseHelper;
import fit.decorator.util.Timer;
import java.text.ParseException;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class FixtureDecoratorTestCase
extends TestCase {
    protected static final long ELAPSED = 20L;
    protected Timer stopWatch = new /* Unavailable Anonymous Inner Class!! */;

    public void testShouldBeAbleToExecuteEncapsulatedFixture() throws ParseException {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>100</td><td>4</td><td>25</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        int right = 1 + this.numberOfAssertionsOnDecorator();
        TestCaseHelper.assertCounts((Counts)TestCaseHelper.counts((int)right, (int)0, (int)0, (int)0), (Counts)decorator.counts);
    }

    public void testShouldBeAbleToFindEncapsulatedFixtureName() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>eg.Division</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        String encapsulatedFixtureName = (String)decorator.summary.get("EncapsulatedFixtureName");
        FixtureDecoratorTestCase.assertEquals((String)"eg.Division", (String)encapsulatedFixtureName);
    }

    public void testShouldBeAbleToInstantiateEncapsulatedFixture() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>" + TestFixture.class.getName() + "</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        String encapsulatedFixtureName = (String)decorator.summary.get("EncapsulatedFixtureName");
        FixtureDecoratorTestCase.assertEquals((String)"fit.decorator.TestFixture", (String)encapsulatedFixtureName);
    }

    public void testShouldDoNothingIfThereIsNoEncapsulatedFixturePresent() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "</table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        FixtureDecoratorTestCase.assertNull(decorator.summary.get("EncapsulatedFixtureName"));
        TestCaseHelper.assertCounts((Counts)TestCaseHelper.counts((int)0, (int)0, (int)0, (int)0), (Counts)decorator.counts);
    }

    public void testShouldMarkExceptionIfEncapsulatingFixtureNameIsInvalid() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>invalidClass</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        FixtureDecoratorTestCase.assertEquals((int)1, (int)decorator.counts.exceptions);
        String encapsulatedFixtureName = (String)decorator.summary.get("EncapsulatedFixtureName");
        FixtureDecoratorTestCase.assertEquals((String)"invalidClass", (String)encapsulatedFixtureName);
    }

    public void testShouldStripFirstRowAndPassRestOfTheTableToEncapsulatedFixture() throws Exception {
        String fitPage = "<table>" + this.geDecoratorHTMLRow() + "<tr><td>" + TestFixture.class.getName() + "</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        String expectedTableContents = "<table><tr><td>" + TestFixture.class.getName() + "</td></tr></table>";
        FixtureDecoratorTestCase.assertEquals((Object)expectedTableContents, decorator.summary.get("tableContents"));
    }

    public void testShouldHandleInvalidInputExceptionIfThrownBySetUpMethod() throws Exception {
        String fitPage = "<table>" + this.geWrongDecoratorHTMLRow() + "<tr><td>" + TestFixture.class.getName() + "</td></tr></table>";
        Fixture decorator = new Fixture();
        decorator.doTables(new Parse(fitPage));
        TestCaseHelper.assertCounts((Counts)TestCaseHelper.counts((int)0, (int)0, (int)0, (int)1), (Counts)decorator.counts);
    }

    public void testSetAlternativeArgsShouldStoreOddNumberedColumnsToArgsVariable() throws Exception {
        String fitPage = "<table><tr><td>xyz</td><td>1</td><td>skip1</td><td>2</td><td>skip2</td><td>3</td><td>skip3</td></tr></table>";
        FixtureDecorator decorator = this.dummyFitDecorator();
        Parse table = new Parse(fitPage);
        decorator.setAlternativeArgs(table);
        this.assertArray(new String[]{"1", "2", "3"}, decorator.getArgs());
    }

    public void testSetAlternativeArgsShouldIgnoreExpectedAndActualStrings() throws Exception {
        String fitPage = "<table><tr><td>xyz</td><td>1</td><td>skip1</td><td>2<hr>actual 4</td><td>skip2</td><td>3</td><td>skip3</td></tr></table>";
        FixtureDecorator decorator = this.dummyFitDecorator();
        Parse table = new Parse(fitPage);
        decorator.setAlternativeArgs(table);
        this.assertArray(new String[]{"1", "2", "3"}, decorator.getArgs());
    }

    private FixtureDecorator dummyFitDecorator() {
        2 decorator = new /* Unavailable Anonymous Inner Class!! */;
        return decorator;
    }

    private void assertArray(String[] expected, String[] actual) {
        FixtureDecoratorTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            FixtureDecoratorTestCase.assertEquals((String)expected[i], (String)actual[i]);
        }
    }

    private String geWrongDecoratorHTMLRow() {
        return "<tr><td>" + Loop.class.getName() + "</td></tr>";
    }

    protected abstract String geDecoratorHTMLRow();

    protected abstract int numberOfAssertionsOnDecorator();

    protected void executeAndAssert(Counts expected, String fitPage, Fixture fixture) throws ParseException {
        fixture.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts((Counts)expected, (Counts)fixture.counts);
    }
}

