/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator.performance;

import fit.ColumnFixture;
import fit.Counts;
import fit.Fixture;
import fit.Parse;
import fit.decorator.FixtureDecoratorTestCase;
import fit.decorator.Loop;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.performance.MaxTime;
import fit.decorator.util.TestCaseHelper;
import java.text.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class MaxTimeTest
extends FixtureDecoratorTestCase {
    private static final String FIRST_HTML_ROW = "<tr><td>" + MaxTime.class.getName() + "</td><td>100</td><td>milliseconds</td></tr>";
    private MaxTime decorator = new MaxTime();

    public void testRunShouldMeasureTimeTakenToExecuteDoTableMethodOnGivenFixture() throws Exception {
        String fitPage = "<table><tr><td>eg.Division</td></tr><tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr><tr><td>100</td><td>4</td><td>25</td></tr></table>";
        MaxTime fixture = new MaxTime(this.stopWatch);
        fixture.run((Fixture)new ColumnFixture(), new Parse(fitPage));
        MaxTimeTest.assertEquals((long)20L, (long)((Long)fixture.summary.get("actualTimeTaken")));
    }

    public void testSetupDecoratorMustThrowInvalidInputExceptionIfMaxTimeIsNotSpecified() throws ParseException {
        try {
            this.decorator.setupDecorator(new String[0]);
            MaxTimeTest.fail((String)"Should blow up ");
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    public void testSetupDecoratorShouldAddMaxTimeToSummary() throws Exception {
        this.decorator.setupDecorator(new String[]{"80"});
        MaxTimeTest.assertEquals((long)80L, (long)((Long)this.decorator.summary.get("maxTime")));
    }

    public void testShouldFailIfActualExecutionTimeIsGreaterThanMaxtime() throws Exception {
        String fitPage = "<table><tr><td>" + MaxTime.class.getName() + "</td><td>19</td><td>milliseconds</td>" + "</tr><tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr><tr><td>12.6</td><td>3</td><td>4.2</td></tr>" + "<tr><td>100</td><td>4</td><td>25</td></tr></table>";
        Counts expected = TestCaseHelper.counts((int)3, (int)1, (int)0, (int)0);
        this.executeAndAssert(expected, fitPage, (Fixture)new MaxTime(this.stopWatch));
    }

    public void testShouldPassIfActualExecutionTimeIsEqualToMaxtime() throws Exception {
        String fitPage = "<table><tr><td>" + MaxTime.class.getName() + "</td><td>20</td><td>milliseconds</td></tr><tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr><tr><td>12.6</td><td>3</td><td>4.2</td></tr>" + "<tr><td>100</td><td>4</td><td>25</td></tr></table>";
        Counts expected = TestCaseHelper.counts((int)4, (int)0, (int)0, (int)0);
        this.executeAndAssert(expected, fitPage, (Fixture)new MaxTime(this.stopWatch));
    }

    public void testShouldPassIfActualExecutionTimeIsLessThanMaxtime() throws Exception {
        String fitPage = "<table><tr><td>" + MaxTime.class.getName() + "</td><td>80</td><td>milliseconds</td></tr><tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr><tr><td>12.6</td><td>3</td><td>4.2</td></tr>" + "<tr><td>100</td><td>4</td><td>25</td></tr></table>";
        Counts expected = TestCaseHelper.counts((int)4, (int)0, (int)0, (int)0);
        this.executeAndAssert(expected, fitPage, (Fixture)new MaxTime(this.stopWatch));
    }

    public void testShouldWorkIfFitureDecoratorsArePiped() throws Exception {
        String fitPage = "<table><tr><td>" + MaxTime.class.getName() + "</td><td>80</td><td>milliseconds</td></tr><tr><td>" + Loop.class.getName() + "</td><td>3</td><td>time</td></tr><tr><td>" + MaxTime.class.getName() + "</td><td>80</td><td>milliseconds</td></tr><tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr><tr><td>12.6</td><td>3</td><td>4.2</td></tr>" + "<tr><td>100</td><td>4</td><td>25</td></tr></table>";
        Counts expected = TestCaseHelper.counts((int)13, (int)0, (int)0, (int)0);
        this.executeAndAssert(expected, fitPage, (Fixture)new MaxTime(this.stopWatch));
    }

    protected String geDecoratorHTMLRow() {
        return FIRST_HTML_ROW;
    }

    protected int numberOfAssertionsOnDecorator() {
        return 1;
    }
}

