/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseExpediter;
import fitnesse.FitNesseExpediterTest;
import fitnesse.authentication.Authenticator;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseParser;
import fitnesse.http.ResponseSender;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.util.MockSocket;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class FitNesseExpediterTest
extends RegexTestCase {
    private FitNesseExpediter expediter;
    private MockSocket socket;
    private FitNesseContext context;
    private InMemoryPage root;
    private PipedInputStream clientInput;
    private PipedOutputStream clientOutput;
    private ResponseParser response;

    public void setUp() throws Exception {
        this.root = (InMemoryPage)InMemoryPage.makeRoot((String)"RooT");
        this.root.addChildPage("FrontPage");
        this.socket = new MockSocket();
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.expediter = new FitNesseExpediter((Socket)this.socket, this.context);
    }

    public void tearDown() throws Exception {
    }

    public void testAuthenticationGetsCalled() throws Exception {
        this.context = FitNesseUtil.makeTestContext((FitNesseContext)this.context, (Authenticator)new StoneWallAuthenticator(this));
        this.expediter = new FitNesseExpediter((Socket)this.socket, this.context);
        MockRequest request = new MockRequest();
        Response response = this.expediter.createGoodResponse((Request)request);
        FitNesseExpediterTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testClosedSocketMidResponse() throws Exception {
        try {
            MockRequest request = new MockRequest();
            Response response = this.expediter.createGoodResponse((Request)request);
            this.socket.close();
            response.sendTo((ResponseSender)this.expediter);
        }
        catch (IOException e) {
            FitNesseExpediterTest.fail((String)"no IOException should be thrown");
        }
    }

    public void testIncompleteRequestsTimeOut() throws Exception {
        FitNesseExpediter sender = this.preparePipedFitNesseExpediter();
        Thread senderThread = this.makeSendingThread(sender);
        senderThread.start();
        Thread parseResponseThread = this.makeParsingThread();
        parseResponseThread.start();
        Thread.sleep(sender.requestParsingTimeLimit + 100L);
        parseResponseThread.join();
        FitNesseExpediterTest.assertEquals((int)408, (int)this.response.getStatus());
    }

    private FitNesseExpediter preparePipedFitNesseExpediter() throws Exception {
        PipedInputStream socketInput = new PipedInputStream();
        this.clientOutput = new PipedOutputStream(socketInput);
        this.clientInput = new PipedInputStream();
        PipedOutputStream socketOutput = new PipedOutputStream(this.clientInput);
        MockSocket socket = new MockSocket((InputStream)socketInput, (OutputStream)socketOutput);
        FitNesseExpediter sender = new FitNesseExpediter((Socket)socket, this.context);
        sender.requestParsingTimeLimit = 200L;
        return sender;
    }

    public void testCompleteRequest() throws Exception {
        FitNesseExpediter sender = this.preparePipedFitNesseExpediter();
        Thread senderThread = this.makeSendingThread(sender);
        senderThread.start();
        Thread parseResponseThread = this.makeParsingThread();
        parseResponseThread.start();
        this.clientOutput.write("GET /root HTTP/1.1\r\n\r\n".getBytes());
        this.clientOutput.flush();
        parseResponseThread.join();
        FitNesseExpediterTest.assertEquals((int)200, (int)this.response.getStatus());
    }

    public void testSlowButCompleteRequest() throws Exception {
        FitNesseExpediter sender = this.preparePipedFitNesseExpediter();
        Thread senderThread = this.makeSendingThread(sender);
        senderThread.start();
        Thread parseResponseThread = this.makeParsingThread();
        parseResponseThread.start();
        byte[] bytes = "GET /root HTTP/1.1\r\n\r\n".getBytes();
        try {
            for (int i = 0; i < bytes.length; ++i) {
                byte aByte = bytes[i];
                this.clientOutput.write(aByte);
                this.clientOutput.flush();
                Thread.sleep(20L);
            }
        }
        catch (IOException pipedClosed) {
            // empty catch block
        }
        parseResponseThread.join();
        FitNesseExpediterTest.assertEquals((int)200, (int)this.response.getStatus());
    }

    private Thread makeSendingThread(FitNesseExpediter sender) {
        Thread senderThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return senderThread;
    }

    private Thread makeParsingThread() {
        Thread parseResponseThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return parseResponseThread;
    }

    static /* synthetic */ ResponseParser access$002(FitNesseExpediterTest x0, ResponseParser x1) {
        x0.response = x1;
        return x0.response;
    }

    static /* synthetic */ PipedInputStream access$100(FitNesseExpediterTest x0) {
        return x0.clientInput;
    }
}

