/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import util.Clock;

/*
 * Exception performing whole class analysis ignored.
 */
public class RecentChanges {
    private static final String RECENT_CHANGES = "RecentChanges";

    private static SimpleDateFormat makeDateFormat() {
        return new SimpleDateFormat("kk:mm:ss EEE, MMM dd, yyyy");
    }

    public static void updateRecentChanges(PageData pageData) {
        RecentChanges.createRecentChangesIfNecessary((PageData)pageData);
        RecentChanges.addCurrentPageToRecentChanges((PageData)pageData);
    }

    public static List<String> getRecentChangesLines(PageData recentChangesdata) {
        String content = recentChangesdata.getContent();
        BufferedReader reader = new BufferedReader(new StringReader(content));
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read recent changes", e);
        }
        return lines;
    }

    private static void addCurrentPageToRecentChanges(PageData data) {
        WikiPage recentChanges = data.getWikiPage().getPageCrawler().getRoot(data.getWikiPage()).getChildPage("RecentChanges");
        String resource = RecentChanges.resource((PageData)data);
        PageData recentChangesdata = recentChanges.getData();
        List lines = RecentChanges.getRecentChangesLines((PageData)recentChangesdata);
        RecentChanges.removeDuplicate((List)lines, (String)resource);
        lines.add(0, RecentChanges.makeRecentChangesLine((PageData)data));
        RecentChanges.trimExtraLines((List)lines);
        String content = RecentChanges.convertLinesToWikiText((List)lines);
        recentChangesdata.setContent(content);
        recentChanges.commit(recentChangesdata);
    }

    private static String resource(PageData data) {
        WikiPagePath fullPath = data.getWikiPage().getPageCrawler().getFullPath(data.getWikiPage());
        String resource = PathParser.render((WikiPagePath)fullPath);
        return resource;
    }

    private static void createRecentChangesIfNecessary(PageData data) {
        PageCrawler crawler = data.getWikiPage().getPageCrawler();
        WikiPage root = crawler.getRoot(data.getWikiPage());
        if (!root.hasChildPage("RecentChanges")) {
            crawler.addPage(root, PathParser.parse((String)"RecentChanges"), "");
        }
    }

    private static String makeRecentChangesLine(PageData data) {
        String user = data.getAttribute("LastModifyingUser");
        if (user == null) {
            user = "";
        }
        return "|" + RecentChanges.resource((PageData)data) + "|" + user + "|" + RecentChanges.makeDateFormat().format(Clock.currentDate()) + "|";
    }

    private static void removeDuplicate(List<String> lines, String resource) {
        ListIterator<String> iterator = lines.listIterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!s.startsWith("|" + resource + "|")) continue;
            iterator.remove();
        }
    }

    private static String convertLinesToWikiText(List<String> lines) {
        StringBuffer buffer = new StringBuffer();
        for (String s : lines) {
            buffer.append(s).append("\n");
        }
        return buffer.toString();
    }

    private static void trimExtraLines(List<String> lines) {
        while (lines.size() > 100) {
            lines.remove(100);
        }
    }
}

