/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.RegularExpressionWikiPageFinder;
import fitnesse.components.RegularExpressionWikiPageFinderTest;
import fitnesse.components.TraversalListener;
import fitnesse.components.WikiPageFinder;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RegularExpressionWikiPageFinderTest
implements TraversalListener<WikiPage> {
    private WikiPage root;
    private WikiPage pageOne;
    private WikiPage childPage;
    private WikiPage virtualPage;
    private PageCrawler crawler;
    List<WikiPage> foundPages = new ArrayList();
    private WikiPageFinder pageFinder;

    public void process(WikiPage page) {
        this.foundPages.add(page);
    }

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.pageOne = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"), "has PageOne content");
        this.childPage = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne.PageOneChild"), "PageChild is a child of PageOne");
        this.virtualPage = this.crawler.addPage(this.root, PathParser.parse((String)"PageTwo"), "PageTwo has a bit of content too\n^PageOneChild");
        PageData data = this.virtualPage.getData();
        this.virtualPage.commit(data);
        this.foundPages.clear();
    }

    @Test
    public void searcher() throws Exception {
        this.pageFinder = this.pageFinder("has");
        this.pageFinder.search(this.root);
        Assert.assertThat((Object)this.foundPages, (Matcher)this.found(new WikiPage[]{this.pageOne, this.virtualPage}));
    }

    @Test
    public void searcherAgain() throws Exception {
        this.pageFinder = this.pageFinder("a");
        this.pageFinder.search(this.root);
        Assert.assertThat((Object)this.foundPages, (Matcher)this.found(new WikiPage[]{this.pageOne, this.childPage, this.virtualPage}));
    }

    @Test
    public void dontSearchProxyPages() throws Exception {
        this.pageFinder = this.pageFinder("a");
        this.pageFinder.search(this.virtualPage);
        Assert.assertEquals((long)1L, (long)this.foundPages.size());
    }

    @Test
    public void observing() throws Exception {
        this.pageFinder = this.pageFinder("has");
        this.pageFinder.search(this.root);
        Assert.assertEquals((long)2L, (long)this.foundPages.size());
    }

    @Test
    public void pagesNotMatching() throws Exception {
        this.pageFinder = this.pageFinder(this.notMatchingSearchText());
        this.pageFinder.search(this.root);
        Assert.assertThat((Object)this.foundPages, (Matcher)this.isEmpty());
    }

    @Test
    public void singlePageMatches() throws Exception {
        this.pageFinder = this.pageFinder(this.matchTextForPageOne());
        this.pageFinder.search(this.root);
        Assert.assertThat((Object)this.foundPages, (Matcher)this.found(new WikiPage[]{this.pageOne}));
    }

    @Test
    public void multiplePageMatch() throws Exception {
        this.pageFinder = this.pageFinder(this.matchAll());
        this.pageFinder.search(this.root);
        Assert.assertThat((Object)this.foundPages, (Matcher)this.found(new WikiPage[]{this.root, this.pageOne, this.childPage, this.virtualPage}));
    }

    @Test
    public void matchesSublevels() throws Exception {
        this.pageFinder = this.pageFinder(this.matchAll());
        this.pageFinder.search(this.pageOne);
        Assert.assertThat((Object)this.foundPages, (Matcher)this.found(new WikiPage[]{this.pageOne, this.childPage}));
    }

    private String matchAll() {
        return ".*";
    }

    private String matchTextForPageOne() {
        return "PageOne content";
    }

    private String notMatchingSearchText() {
        return "this search text does not match any page";
    }

    private WikiPageFinder pageFinder(String searchText) {
        return new RegularExpressionWikiPageFinder(searchText, (TraversalListener)this);
    }

    private Matcher<List<WikiPage>> found(WikiPage ... pages) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Matcher<List<WikiPage>> isEmpty() {
        return new EmptyListMatcher(null);
    }
}

