/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.components.TraversalListener;
import fitnesse.components.WikiPageFinder;
import fitnesse.wiki.WikiPage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuiteSpecificationMatchFinder
extends WikiPageFinder {
    private String titleRegEx;
    private String contentRegEx;

    public SuiteSpecificationMatchFinder(String titleRegEx, String contentRegEx, TraversalListener<? super WikiPage> observer) {
        super(observer);
        this.titleRegEx = titleRegEx;
        this.contentRegEx = contentRegEx;
    }

    protected boolean pageMatches(WikiPage page) {
        if (!this.nullOrEmpty(this.titleRegEx) && !this.nullOrEmpty(this.contentRegEx)) {
            return this.patternMatches(this.titleRegEx, page.getName()) && this.patternMatches(this.contentRegEx, page.getData().getContent());
        }
        if (this.patternMatches(this.titleRegEx, page.getName())) {
            return true;
        }
        return this.patternMatches(this.contentRegEx, page.getData().getContent());
    }

    private boolean patternMatches(String regEx, String subject) {
        Pattern pattern;
        Matcher matcher;
        return !this.nullOrEmpty(regEx) && (matcher = (pattern = Pattern.compile(regEx, 32)).matcher(subject)).find();
    }

    private boolean nullOrEmpty(String regEx) {
        return regEx == null || regEx.equals("");
    }
}

