/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseExpediter;
import fitnesse.authentication.OneUserAuthenticator;
import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.fixtures.PageCreator;
import fitnesse.fixtures.PageDriver;
import fitnesse.fixtures.ResponseExaminer;
import fitnesse.fixtures.ResponseRequester;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.util.MockSocket;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.NodeList;
import org.json.JSONObject;

public class PageDriver {
    private PageCreator creator = new PageCreator();
    private ResponseRequester requester = new ResponseRequester();
    private ResponseExaminer examiner = new ResponseExaminer();
    private Map<String, String> hash;

    public void createPageWithContent(String pageName, String content) throws Exception {
        this.creator.pageName = pageName;
        this.creator.pageContents = content;
        this.creator.valid();
    }

    public void createPageWithAuthentication(String pageName, String attributes) throws Exception {
        this.creator.pageAttributes = attributes;
        this.creator.pageContents = "nothing";
        this.createPageWithContent(pageName, "");
    }

    public int requestPage(String uri) throws Exception {
        this.requester.uri = uri;
        this.requester.execute();
        return this.requester.status();
    }

    public int requestPageAuthenticatedByUserAndPassword(String uri, String user, String password) throws Exception {
        this.requester.username = user;
        this.requester.password = password;
        return this.requestPage(uri);
    }

    public int requestPageSaveWithContentsByUserAndPassword(String pageName, String contents, String username, String password) throws Exception {
        MockRequest request = new MockRequest();
        if (username != null) {
            request.setCredentials(username, password);
        }
        request.addInput("responder", (Object)"saveData");
        request.addInput("editTime", (Object)"9999999999999");
        request.addInput("ticketId", (Object)"321");
        request.addInput("pageContent", (Object)contents);
        request.parseRequestUri("/" + pageName);
        WikiPagePath path = PathParser.parse((String)request.getResource());
        FitnesseFixtureContext.page = FitnesseFixtureContext.root.getPageCrawler().getPage(FitnesseFixtureContext.root, path);
        FitNesseExpediter expediter = new FitNesseExpediter((Socket)new MockSocket(""), FitnesseFixtureContext.context);
        FitnesseFixtureContext.response = expediter.createGoodResponse((Request)request);
        FitnesseFixtureContext.sender = new MockResponseSender();
        FitnesseFixtureContext.sender.doSending(FitnesseFixtureContext.response);
        return FitnesseFixtureContext.response.getStatus();
    }

    public int requestPageSaveWithContents(String pageName, String contents) throws Exception {
        return this.requestPageSaveWithContentsByUserAndPassword(pageName, contents, null, null);
    }

    public String lastModifiedOfPage(String pageName) throws Exception {
        WikiPage root = FitnesseFixtureContext.root;
        WikiPagePath pagePath = PathParser.parse((String)pageName);
        WikiPage thePage = root.getPageCrawler().getPage(root, pagePath);
        PageData data = thePage.getData();
        return data.getAttribute("LastModifyingUser");
    }

    public boolean pageIsASymbolicLink(String pageName) {
        WikiPage root = FitnesseFixtureContext.root;
        WikiPagePath pagePath = PathParser.parse((String)pageName);
        WikiPage thePage = root.getPageCrawler().getPage(root, pagePath);
        return thePage instanceof SymbolicPage;
    }

    public boolean pageExists(String pageName) {
        WikiPage root = FitnesseFixtureContext.root;
        WikiPagePath pagePath = PathParser.parse((String)pageName);
        WikiPage thePage = root.getPageCrawler().getPage(root, pagePath);
        return thePage != null;
    }

    public void makeATestPage(String pageName) throws Exception {
        this.onPageSetAttribute(pageName, "Test");
    }

    public void makeASuitePage(String pageName) throws Exception {
        this.onPageSetAttribute(pageName, "Suite");
    }

    private void onPageSetAttribute(String pageName, String attrName) {
        WikiPage root = FitnesseFixtureContext.root;
        WikiPagePath pagePath = PathParser.parse((String)pageName);
        WikiPage thePage = root.getPageCrawler().getPage(root, pagePath);
        PageData data = thePage.getData();
        data.setAttribute(attrName, "true");
        thePage.commit(data);
    }

    public boolean contentMatches(String pattern) throws Exception {
        this.examiner.type = "contents";
        this.examiner.pattern = pattern;
        return this.examiner.matches();
    }

    public boolean contentContains(String subString) throws Exception {
        this.examiner.type = "contents";
        this.examiner.extractValueFromResponse();
        return this.examiner.getValue().contains(subString);
    }

    public boolean htmlContains(String subString) throws Exception {
        String html = this.requester.html();
        html = html.replaceAll("\n", " ");
        html = html.replaceAll("\r", " ");
        html = html.replaceAll("\\s+", " ");
        System.out.println("html = " + html);
        System.out.println("subString = " + subString);
        return html.contains(subString);
    }

    public boolean containsJsonPacket(String packet) throws Exception {
        packet = ResponseExaminer.convertBreaksToLineSeparators((String)packet);
        System.out.println("packet = " + packet);
        JSONObject expected = new JSONObject(packet);
        String contentString = this.requester.contents();
        int jsonStart = contentString.indexOf("{");
        if (jsonStart == -1) {
            return false;
        }
        contentString = contentString.substring(jsonStart);
        System.out.println("contentString = " + contentString);
        JSONObject actual = new JSONObject(contentString);
        return expected.toString(1).equals(actual.toString(1));
    }

    public String content() throws Exception {
        return this.requester.html();
    }

    public String lineIs(int lineNumber) throws Exception {
        this.examiner.type = "line";
        this.examiner.number = lineNumber;
        return this.examiner.string();
    }

    public int lineNumberContaining(String text) throws Exception {
        String content = this.requester.html();
        int textPosition = content.indexOf(text);
        if (textPosition == -1) {
            return -1;
        }
        String priorToContent = content.substring(0, textPosition);
        String[] lines = priorToContent.split("\n");
        return lines.length;
    }

    public int countOfTagWithIdPrefix(String tag, String idPrefix) throws Exception {
        AndFilter filter = new AndFilter((NodeFilter)new TagNameFilter(tag), (NodeFilter)new HasAttributePrefixFilter("id", idPrefix));
        return this.getMatchingTags((NodeFilter)filter).size();
    }

    private NodeList getMatchingTags(NodeFilter filter) throws Exception {
        String html = this.examiner.html();
        Parser parser = new Parser(new Lexer(new Page(html)));
        NodeList list = parser.parse(null);
        NodeList matches = list.extractAllNodesThatMatch(filter, true);
        return matches;
    }

    public String pageHistoryDateSignatureOf(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(date);
    }

    public int countOfTagWithIdAndWithClassBelowTagWithIdPrefix(String childTag, String childId, String tagClass, String parentTag, String parentIdPrefix) throws Exception {
        NodeList parents = this.getMatchingTags((NodeFilter)new AndFilter((NodeFilter)new TagNameFilter(parentTag), (NodeFilter)new HasAttributePrefixFilter("id", parentIdPrefix)));
        NodeFilter[] predicates = new NodeFilter[]{new TagNameFilter(childTag), new HasAttributeFilter("class", tagClass), new HasAttributeFilter("id", childId)};
        AndFilter filter = new AndFilter(predicates);
        NodeList matches = parents.extractAllNodesThatMatch((NodeFilter)filter, true);
        return matches.size();
    }

    public String valueOfTagWithIdIs(String id) throws Exception {
        return this.getValueOfTagWithAttributeValue("id", id);
    }

    private String getValueOfTagWithAttributeValue(String attribute, String value) throws Exception {
        NodeList matches = this.getMatchingTags((NodeFilter)new HasAttributeFilter(attribute, value));
        if (matches.size() != 1) {
            return String.format("There are %d matches, there should be 1.", matches.size());
        }
        return matches.elementAt(0).toHtml();
    }

    public String valueOfTagWithClassIs(String classValue) throws Exception {
        return this.getValueOfTagWithAttributeValue("class", classValue);
    }

    public boolean contentOfTagWithIdContains(String id, String contents) throws Exception {
        String html = this.getValueOfTagWithAttributeValue("id", id);
        return html.contains(contents);
    }

    public String contentOfTagWithId(String id) throws Exception {
        return this.getValueOfTagWithAttributeValue("id", id);
    }

    public boolean pageHasAttribute(String fullPathOfPage, String attribute) throws Exception {
        PageCrawler crawler = FitnesseFixtureContext.root.getPageCrawler();
        WikiPage page = crawler.getPage(FitnesseFixtureContext.root, PathParser.parse((String)fullPathOfPage));
        PageData data = page.getData();
        return data.hasAttribute(attribute);
    }

    public void givenUserWithPassword(String user, String password) {
        FitNesseContext.Builder builder = new FitNesseContext.Builder(FitnesseFixtureContext.context);
        builder.authenticator = new OneUserAuthenticator(user, password);
        FitnesseFixtureContext.context = builder.createFitNesseContext();
    }

    public void sendAsHash(Map<String, String> hash) {
        this.hash = hash;
    }

    public String hashIs(String key) {
        return (String)this.hash.get(key);
    }
}

