/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.ResponseParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResponseParserTest
extends TestCase {
    private String response;
    private InputStream input;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testParsing() throws Exception {
        this.response = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nContent-Length: 12\r\nCache-Control: max-age=0\r\n\r\nsome content";
        this.input = new ByteArrayInputStream(this.response.getBytes());
        ResponseParser parser = new ResponseParser(this.input);
        ResponseParserTest.assertEquals((int)200, (int)parser.getStatus());
        ResponseParserTest.assertEquals((String)"text/html", (String)parser.getHeader("Content-Type"));
        ResponseParserTest.assertEquals((String)"some content", (String)parser.getBody());
    }

    public void testChunkedResponse() throws Exception {
        this.response = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nTransfer-Encoding: chunked\r\n\r\n3\r\n123\r\n7\r\n4567890\r\n0\r\nTail-Header: TheEnd!\r\n";
        this.input = new ByteArrayInputStream(this.response.getBytes());
        ResponseParser parser = new ResponseParser(this.input);
        ResponseParserTest.assertEquals((int)200, (int)parser.getStatus());
        ResponseParserTest.assertEquals((String)"text/html", (String)parser.getHeader("Content-Type"));
        ResponseParserTest.assertEquals((String)"1234567890", (String)parser.getBody());
        ResponseParserTest.assertEquals((String)"TheEnd!", (String)parser.getHeader("Tail-Header"));
    }
}

