/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.JUnitHelper;
import fitnesse.responders.run.JavaFormatter;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JUnitHelperExampleTest {
    JUnitHelper helper;
    String[] expectedTests = new String[]{"FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ErikPragtBug", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.HashTableTests.ShouldConvertHashWidgetToHashTable", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.LibrarySuite.LastLibraryPreceedsEarlierLibraryTest", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.LibrarySuite.LibraryInSetUpSuite.LibraryInSetUpAndPageTest", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.LibrarySuite.LibraryInSetUpSuite.LibraryInSetUpTest", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.LibrarySuite.OneLibraryTest", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.MultiByteCharsInSlim", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ParameterizedScenarios", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ScenarioLibraryTestSuite.BlankCellsInNestedScenariosShouldWork", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ScenarioLibraryTestSuite.BrotherScenarioLibraryIsIncluded", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ScenarioLibraryTestSuite.ManyUnclesAreIncluded", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ScenarioLibraryTestSuite.NoScenarioSectionIfThereAreNone", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ScenarioLibraryTestSuite.ScenarioLibrariesAreIncludedInTheCorrectOrder", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ScenarioLibraryTestSuite.ScenarioLibrariesOnlyIncludedInTestPages", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ScenarioLibraryTestSuite.ScenariosOnlyInSlimTests", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.SlimSymbolsCanBeBlankOrNull", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.SystemUnderTestTest", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.TableTableReturnsNull", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.TestCanPassSymbolsIntoConstructors", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.TestComparators", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.SlimSymbolDollarDollar", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.TestOrderedQueryWithDuplicateRows", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.TestPageWithInclude", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.TestSequentialArgumentProcessing", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.TestSubsetQuery", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.TestSymbolsDontGetTurnedToStringsInTheOutput", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.TestTwoIdenticalTablesOnPageDontConflict", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.RegularExpressionMatching", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ChainTest"};
    private String[] expectedTestsWithSuiteFilter = new String[]{"FitNesse.SuiteAcceptanceTests.SuiteSlimTests.ErikPragtBug", "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.MultiByteCharsInSlim"};

    @Before
    public void prepare() {
        this.helper = new JUnitHelper(".", new File(System.getProperty("java.io.tmpdir"), "fitnesse").getAbsolutePath());
        JavaFormatter.dropInstance((String)"FitNesse.SuiteAcceptanceTests.SuiteSlimTests");
    }

    @Test
    public void assertTestPasses_RunsATestThroughFitNesseAndWeCanInspectTheResultUsingJavaFormatter() throws Exception {
        String testName = "FitNesse.SuiteAcceptanceTests.SuiteSlimTests.SystemUnderTestTest";
        this.helper.assertTestPasses(testName);
        JavaFormatter formatter = JavaFormatter.getInstance((String)testName);
        Assert.assertEquals((Object)testName, formatter.getTestsExecuted().get(0));
        Assert.assertEquals((long)1L, (long)formatter.getTestsExecuted().size());
    }

    @Test
    public void assertSuitePasses_appliesSuiteFilterIfDefined() throws Exception {
        this.helper.assertSuitePasses("FitNesse.SuiteAcceptanceTests.SuiteSlimTests", "testSuite");
        JavaFormatter formatter = JavaFormatter.getInstance((String)"FitNesse.SuiteAcceptanceTests.SuiteSlimTests");
        Assert.assertEquals(new HashSet<String>(Arrays.asList(this.expectedTestsWithSuiteFilter)), new HashSet(formatter.getTestsExecuted()));
    }

    @Test
    public void helperWillFailTestsIfNoTestsAreExecuted() throws Exception {
        try {
            this.helper.assertSuitePasses("FitNesse.SuiteAcceptanceTests.SuiteSlimTests", "nonExistingFilter");
        }
        catch (AssertionError ae) {
            Assert.assertTrue((boolean)((Throwable)((Object)ae)).getMessage().startsWith("at least one test"));
        }
        JavaFormatter formatter = JavaFormatter.getInstance((String)"FitNesse.SuiteAcceptanceTests.SuiteSlimTests");
        Assert.assertEquals(new HashSet(), new HashSet(formatter.getTestsExecuted()));
    }

    @Test
    public void dummy() {
    }
}

