/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.responders.run.ResultsListener;
import fitnesse.testsystems.CompositeExecutionLog;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.slim.results.ExceptionResult;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import util.TimeMeasurement;

public class JUnitXMLTestListener
implements ResultsListener {
    private String outputPath;

    public JUnitXMLTestListener(String outputPath) {
        this.outputPath = outputPath;
        new File(outputPath).mkdirs();
    }

    public void recordTestResult(String testName, TestSummary result, long executionTime) throws IOException {
        int errors = 0;
        int failures = 0;
        String failureXml = "";
        if (result.exceptions + result.wrong > 0) {
            failureXml = "<failure type=\"java.lang.AssertionError\" message=\" exceptions: " + result.exceptions + " wrong: " + result.wrong + "\"></failure>";
            if (result.exceptions > 0) {
                errors = 1;
            } else {
                failures = 1;
            }
        }
        String resultXml = "<testsuite errors=\"" + errors + "\" skipped=\"0\" tests=\"1\" time=\"" + (double)executionTime / 1000.0 + "\" failures=\"" + failures + "\" name=\"" + testName + "\">" + "<properties></properties>" + "<testcase classname=\"" + testName + "\" time=\"" + (double)executionTime / 1000.0 + "\" name=\"" + testName + "\">" + failureXml + "</testcase>" + "</testsuite>";
        String finalPath = new File(this.outputPath, "TEST-" + testName + ".xml").getAbsolutePath();
        FileWriter fw = new FileWriter(finalPath);
        fw.write(resultXml);
        fw.close();
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) {
    }

    public void announceNumberTestsToRun(int testsToRun) {
    }

    public void errorOccured() {
    }

    public void newTestStarted(TestPage test, TimeMeasurement timeMeasurement) {
    }

    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) {
    }

    public void testComplete(TestPage test, TestSummary testSummary, TimeMeasurement timeMeasurement) throws IOException {
        this.recordTestResult(new WikiPagePath(test.getSourcePage()).toString(), testSummary, timeMeasurement.elapsed());
    }

    public void testOutputChunk(String output) {
    }

    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
    }

    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) {
    }
}

